/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.observer;

import java.util.Calendar;
import java.util.Date;
import nyla.solutions.core.data.clock.TimeInterval;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.decorator.TimeIntervalDecorator;
import nyla.solutions.core.patterns.observer.Subject;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;

public class SubjectTimerObserver
implements SubjectObserver,
TimeInterval {
    private Object startData = null;
    private Object endData = null;
    private TimeIntervalDecorator decorator = null;
    private Date startDate = null;
    private Date endDate = null;
    private String startSubjectNamePattern = null;
    private String endSubjectNamePattern = null;

    public SubjectTimerObserver() {
    }

    public SubjectTimerObserver(TimeIntervalDecorator timeIntervalDecorator) {
        this.decorator = timeIntervalDecorator;
    }

    @Override
    public void update(Subject subject, Object data) {
        Debugger.println(this, "Recieve subject=" + subject);
        if (this.isStart(subject)) {
            this.startData = data;
            this.startDate = Calendar.getInstance().getTime();
            Debugger.printInfo(this, "TIMER START DATE [" + Text.formatDate(this.startDate) + "]\n " + Text.toString(this.startData));
        } else if (this.isEnd(subject)) {
            this.endData = data;
            this.endDate = Calendar.getInstance().getTime();
            Debugger.printInfo(this, "TIMER END DATE [" + this.endDate + "]\n " + this.endData);
            if (this.decorator != null) {
                this.decorator.decorator(this);
            }
        } else {
            throw new SystemException("Unknown subject " + subject.getName());
        }
    }

    public boolean isStart(Subject subject) {
        if (subject == null || subject.getName() == null || this.startSubjectNamePattern == null) {
            return false;
        }
        return Text.matches(subject.getName(), this.startSubjectNamePattern);
    }

    public boolean isEnd(Subject subject) {
        if (subject == null || subject.getName() == null || this.endSubjectNamePattern == null) {
            return false;
        }
        return Text.matches(subject.getName(), this.endSubjectNamePattern);
    }

    @Override
    public String getId() {
        return this.getClass().getName() + " START:" + this.startSubjectNamePattern + " END:" + this.endSubjectNamePattern;
    }

    @Override
    public void setId(String id) {
    }

    public String getStartSubjectNamePattern() {
        return this.startSubjectNamePattern;
    }

    public void setStartSubjectNamePattern(String startSubjectNamePattern) {
        this.startSubjectNamePattern = startSubjectNamePattern;
    }

    public String getEndSubjectNamePattern() {
        return this.endSubjectNamePattern;
    }

    public void setEndSubjectNamePattern(String endSubjectNamePattern) {
        this.endSubjectNamePattern = endSubjectNamePattern;
    }

    public TimeIntervalDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(TimeIntervalDecorator decorator) {
        this.decorator = decorator;
    }

    @Override
    public Date getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return new Date(this.startDate.getTime());
    }

    @Override
    public void setStartDate(Date startDate) {
        if (startDate == null) {
            this.startDate = null;
            return;
        }
        this.startDate = new Date(startDate.getTime());
    }

    @Override
    public Date getEndDate() {
        if (this.endDate == null) {
            return null;
        }
        return new Date(this.endDate.getTime());
    }

    @Override
    public void setEndDate(Date endDate) {
        if (endDate == null) {
            this.endDate = null;
            return;
        }
        this.endDate = new Date(endDate.getTime());
    }

    public Object getStartData() {
        return this.startData;
    }

    public void setStartData(Object startData) {
        this.startData = startData;
    }

    public Object getEndData() {
        return this.endData;
    }

    public void setEndData(Object endData) {
        this.endData = endData;
    }
}

