/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.observer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.patterns.observer.Subject;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.util.Debugger;

public class Topic
implements Subject {
    private String name = this.getClass().getName();
    private Map<String, SubjectObserver> observerMap = new HashMap<String, SubjectObserver>();

    public Topic() {
    }

    public Topic(String name) {
        this.setName(name);
    }

    @Override
    public void add(SubjectObserver subjectObserver) {
        if (subjectObserver == null) {
            throw new RequiredException("subjectObserver in Topic.add");
        }
        String id = subjectObserver.getId();
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Subject observer id required");
        }
        SubjectObserver prev = this.observerMap.get(subjectObserver.getId());
        if (prev != null && prev != subjectObserver) {
            Debugger.println(this, "Object registered, but observer id already exists " + subjectObserver.getId() + " for subject=" + this.name);
        }
        this.observerMap.put(subjectObserver.getId(), subjectObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Object object) {
        SubjectObserver subjectObserver = null;
        Iterator<SubjectObserver> i = this.observerMap.values().iterator();
        while (i.hasNext()) {
            SubjectObserver subjectObserver2 = subjectObserver = i.next();
            synchronized (subjectObserver2) {
                subjectObserver.update(this, object);
            }
        }
    }

    @Override
    public void remove(SubjectObserver subjectObserver) {
        if (subjectObserver == null || subjectObserver.getId() == null || subjectObserver.getId().length() == 0) {
            return;
        }
        this.observerMap.remove(subjectObserver.getId());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Subject)) {
            return -1;
        }
        Subject subject = (Subject)object;
        return this.name.compareTo(subject.getName());
    }

    public void copy(Copier from) {
        if (!(from instanceof Topic)) {
            return;
        }
        Topic topic = (Topic)((Object)from);
        this.name = topic.name;
        this.observerMap = topic.observerMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.observerMap == null ? 0 : this.observerMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Topic other = (Topic)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.observerMap == null ? other.observerMap != null : !this.observerMap.equals(other.observerMap));
    }

    public String toString() {
        return this.getClass().getName() + " name=" + this.name;
    }
}

