/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import nyla.solutions.core.patterns.reflection.ClassSchemaElement;
import nyla.solutions.core.patterns.reflection.ClassSchemaVisitor;
import nyla.solutions.core.patterns.reflection.ClassType;
import nyla.solutions.core.patterns.reflection.ComplexTypeSchema;
import nyla.solutions.core.patterns.reflection.MethodSchema;
import nyla.solutions.core.patterns.reflection.Mirror;
import nyla.solutions.core.patterns.reflection.PrimitiveTypeSchema;
import nyla.solutions.core.patterns.reflection.TypeSchema;

public class ClassSchema
implements Serializable,
ClassSchemaElement {
    private static final long serialVersionUID = -1510907649123959661L;
    private String className;
    private ClassType classType;
    private MethodSchema[] methodSchemas;
    private TypeSchema[] fieldSchemas;
    private Object[] enumConstants;

    public ClassSchema(Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("aClass required");
        }
        this.className = aClass.getName();
        if (Mirror.isPrimitive(aClass)) {
            this.classType = ClassType.primitive;
            return;
        }
        if (aClass.isEnum()) {
            this.classType = ClassType.ENUM;
            this.enumConstants = aClass.getEnumConstants();
            return;
        }
        this.classType = ClassType.generic;
        Field[] fields = aClass.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return;
        }
        ArrayList<TypeSchema> fieldList = new ArrayList<TypeSchema>(fields.length);
        Class<?> fieldClass = null;
        for (int i = 0; i < fields.length; ++i) {
            if ("serialVersionUID".equals(fields[i].getName())) continue;
            fieldClass = fields[i].getType();
            if (Mirror.isPrimitive(fieldClass)) {
                fieldList.add(new PrimitiveTypeSchema(fields[i]));
                continue;
            }
            fieldList.add(new ComplexTypeSchema(fields[i]));
        }
        this.fieldSchemas = new TypeSchema[fieldList.size()];
        fieldList.toArray(this.fieldSchemas);
        Method[] methods = aClass.getMethods();
        if (methods != null) {
            this.methodSchemas = new MethodSchema[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                this.methodSchemas[i] = new MethodSchema(methods[i]);
            }
        }
    }

    public ClassType getClassType() {
        return this.classType;
    }

    @Override
    public void accept(ClassSchemaVisitor visitor) {
        visitor.visitClass(this);
    }

    public String getObjectClassName() {
        return this.className;
    }

    public TypeSchema[] getFieldSchemas() {
        if (this.fieldSchemas == null) {
            return null;
        }
        return (TypeSchema[])this.fieldSchemas.clone();
    }

    public String toString() {
        return "ClassSchema [className=" + this.className + ", classType=" + (Object)((Object)this.classType) + ", methodSchemas=" + Arrays.toString(this.methodSchemas) + ", fieldSchemas=" + Arrays.toString(this.fieldSchemas) + ", enumConstants=" + Arrays.toString(this.enumConstants) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.classType == null ? 0 : this.classType.hashCode());
        result = 31 * result + Arrays.hashCode(this.enumConstants);
        result = 31 * result + Arrays.hashCode(this.fieldSchemas);
        result = 31 * result + Arrays.hashCode(this.methodSchemas);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassSchema other = (ClassSchema)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.classType != other.classType) {
            return false;
        }
        if (!Arrays.equals(this.enumConstants, other.enumConstants)) {
            return false;
        }
        if (!Arrays.equals(this.fieldSchemas, other.fieldSchemas)) {
            return false;
        }
        return Arrays.equals(this.methodSchemas, other.methodSchemas);
    }

    public Object[] getEnumConstants() {
        if (this.enumConstants == null) {
            return null;
        }
        return (Object[])this.enumConstants.clone();
    }
}

