/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nyla.solutions.core.util.Text;

public class ReLookup<T>
implements Map<String, T> {
    private Map<String, T> lookupMap = new TreeMap<String, T>();

    public T lookup(String text) {
        if (text == null) {
            return null;
        }
        for (Map.Entry<String, T> entry : this.lookupMap.entrySet()) {
            if (!Text.matches(text, entry.getKey())) continue;
            return this.lookupMap.get(entry.getKey());
        }
        return null;
    }

    public Collection<T> lookupCollection(String reExpression) {
        if (reExpression == null) {
            return null;
        }
        ArrayList<T> collection = new ArrayList<T>(this.lookupMap.size());
        for (Map.Entry<String, T> entry : this.lookupMap.entrySet()) {
            if (!Text.matches(reExpression, entry.getKey())) continue;
            collection.add(this.lookupMap.get(entry.getKey()));
        }
        collection.trimToSize();
        return collection;
    }

    @Override
    public T get(Object regularExpKey) {
        return this.lookup((String)regularExpKey);
    }

    @Override
    public T put(String regularExpKey, T value) {
        return this.lookupMap.put(regularExpKey, value);
    }

    @Override
    public boolean isEmpty() {
        return this.lookupMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object obj) {
        return this.lookupMap.containsKey(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.lookupMap.containsValue(obj);
    }

    @Override
    public void clear() {
        this.lookupMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.lookupMap.keySet();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.lookupMap.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.lookupMap.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.lookupMap.hashCode();
    }

    @Override
    public int size() {
        return this.lookupMap.size();
    }

    @Override
    public T remove(Object obj) {
        return this.lookupMap.remove(obj);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        this.lookupMap.putAll(map);
    }

    @Override
    public Collection<T> values() {
        return this.lookupMap.values();
    }
}

