/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.search.queryService;

import java.util.Comparator;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.patterns.expression.BooleanExpression;
import nyla.solutions.core.patterns.search.queryService.QuestCriteria;
import nyla.solutions.core.patterns.search.queryService.QuestFinder;
import nyla.solutions.core.patterns.search.queryService.QuestMgr;
import nyla.solutions.core.patterns.search.queryService.QuestService;
import nyla.solutions.core.patterns.servicefactory.ConfigServiceFactory;
import nyla.solutions.core.patterns.workthread.ExecutorBoss;
import nyla.solutions.core.util.Config;

public class QuestFactory {
    private static final QuestFactory questFactory = new QuestFactory();
    private static ExecutorBoss executorBoss = null;
    private static int threadCount = Config.getPropertyInteger(QuestFactory.class, "threadCount");

    private QuestFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorBoss createExecutorBoss() {
        Class<QuestFactory> clazz = QuestFactory.class;
        synchronized (QuestFactory.class) {
            if (executorBoss == null) {
                executorBoss = new ExecutorBoss(threadCount);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorBoss;
        }
    }

    public static QuestFactory getInstance() {
        return questFactory;
    }

    public QuestFinder createFinder(QuestCriteria criteria, String dataSource) {
        try {
            QuestFinder finder = (QuestFinder)ConfigServiceFactory.getConfigServiceFactoryInstance().create(dataSource);
            finder.assignCriteria(criteria, dataSource);
            return finder;
        }
        catch (ConfigException e) {
            throw new ConfigException("Connect create new instance " + QuestFinder.class.getName() + " " + e.getMessage(), e);
        }
    }

    public <T> Comparator<T> createComparator(String name) {
        Comparator comparator = (Comparator)ConfigServiceFactory.getConfigServiceFactoryInstance().create(name);
        return comparator;
    }

    public <T> BooleanExpression<T> createBooleanExpression(String name) {
        BooleanExpression expression = (BooleanExpression)ConfigServiceFactory.getConfigServiceFactoryInstance().create(name);
        return expression;
    }

    public QuestService createQuestService() {
        return new QuestMgr();
    }
}

