/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.servicefactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.SetUpable;
import nyla.solutions.core.patterns.servicefactory.ServiceFactory;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.JavaBean;
import nyla.solutions.core.util.settings.ConfigSettings;
import nyla.solutions.core.util.settings.Settings;

public class ConfigServiceFactory
extends ServiceFactory
implements SetUpable {
    public static final String PROP_PREFIX = Config.getProperty(ConfigServiceFactory.class, "PROP_PREFIX", "factory.");
    private final Settings settings;
    private static ConfigServiceFactory instance = null;
    private static boolean initialized = false;
    private static boolean singletonCreation = Config.getPropertyBoolean(ConfigServiceFactory.class, "singletonCreation", false);
    private static boolean setNestedProperties = Config.getPropertyBoolean(ConfigServiceFactory.class, "setNestedProperties", false);
    private static final HashMap<String, Object> factoryMap = new HashMap();

    public ConfigServiceFactory() {
        this.settings = Config.getSettings();
    }

    public ConfigServiceFactory(String config) {
        Properties props = new Properties();
        try (InputStream is = ClassPath.getSystemResourceAsStream(config);){
            props.load(is);
            this.settings = new ConfigSettings();
            this.settings.setProperties(props);
            Config.setSettings(this.settings);
        }
        catch (IOException e) {
            throw new SetupException("Unable to load resource config:" + config + " error:" + e.getMessage(), e);
        }
    }

    @Override
    public synchronized void setUp() {
        if (initialized) {
            return;
        }
        String className = null;
        Map<Object, Object> properties = this.settings.getProperties();
        String key = null;
        Object serviceObject = null;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            key = String.valueOf(entry.getKey());
            if (!key.startsWith(PROP_PREFIX)) continue;
            try {
                className = (String)entry.getValue();
                serviceObject = Class.forName(className).newInstance();
                factoryMap.put(key, serviceObject);
            }
            catch (Throwable e) {
                throw new SetupException("CLASS:" + className + " ERROR:" + e.getMessage(), e);
            }
        }
        initialized = true;
    }

    @Override
    public <T> T create(Class<?> aClass) {
        return this.create(aClass.getName());
    }

    @Override
    public <T> T create(Class<?> serviceClass, String name) {
        T service = this.create(name);
        return service;
    }

    @Override
    public <T> T create(String aName, Object[] params) {
        if (aName == null || aName.length() == 0) {
            return null;
        }
        String factoryName = PROP_PREFIX + aName;
        Object serviceObj = null;
        if (singletonCreation) {
            serviceObj = factoryMap.get(factoryName.toString());
        }
        if (serviceObj == null) {
            String className = this.settings.getProperty(factoryName, aName);
            serviceObj = ClassPath.newInstance(className, params);
            if (setNestedProperties) {
                this.setProperties(factoryName, serviceObj);
            }
            if (singletonCreation) {
                factoryMap.put(factoryName, serviceObj);
            }
        }
        return (T)serviceObj;
    }

    private void setProperties(String factoryName, Object serviceObj) {
        Set<Object> propertyNames = JavaBean.keySet(serviceObj);
        String configPropertyValue = null;
        String propertyNameText = null;
        for (Object propertyName : propertyNames) {
            propertyNameText = propertyName.toString();
            configPropertyValue = this.settings.getProperty(factoryName + "." + propertyNameText, "");
            if ("".equals(configPropertyValue)) continue;
            JavaBean.setProperty(serviceObj, propertyNameText, configPropertyValue);
        }
    }

    @Override
    public <T> T create(String aName) {
        return this.create(aName, null);
    }

    @Override
    public <T> T create(String aName, Object aParam) {
        Object[] params = new Object[]{aParam};
        return this.create(aName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ConfigServiceFactory getConfigServiceFactoryInstance() {
        Class<ConfigServiceFactory> clazz = ConfigServiceFactory.class;
        synchronized (ConfigServiceFactory.class) {
            if (instance == null) {
                instance = new ConfigServiceFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

