/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.workthread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import nyla.solutions.core.patterns.workthread.StartState;
import nyla.solutions.core.patterns.workthread.StopState;
import nyla.solutions.core.patterns.workthread.SupervisedWorker;
import nyla.solutions.core.patterns.workthread.Supervisor;
import nyla.solutions.core.patterns.workthread.WorkQueue;
import nyla.solutions.core.patterns.workthread.WorkState;
import nyla.solutions.core.patterns.workthread.WorkerThread;

public class Boss
implements Supervisor {
    private WorkState workState = null;
    private WorkQueue workQueue = null;
    private String name = this.getClass().getName();
    private Collection<SupervisedWorker> workers = new HashSet<SupervisedWorker>();

    public Boss() {
    }

    public Boss(WorkQueue workQueue) {
        this.setWorkQueue(workQueue);
    }

    @Override
    public Collection<SupervisedWorker> getWorkers() {
        return new ArrayList<SupervisedWorker>(this.workers);
    }

    public void manage(int workersCount) {
        this.workers.clear();
        WorkerThread worker = null;
        for (int i = 0; i < workersCount; ++i) {
            worker = new WorkerThread(this);
            this.manage(worker);
        }
    }

    public void manage(Collection<SupervisedWorker> workers) {
        if (workers == null) {
            return;
        }
        this.workers.clear();
        SupervisedWorker worker2 = null;
        for (SupervisedWorker worker2 : workers) {
            this.manage(worker2);
        }
    }

    public void startWorkers(int workCount) {
        this.manage(workCount);
        this.setWorkState(new StartState());
    }

    public void startWorkers() {
        this.setWorkState(new StartState());
    }

    public void stopWorkers() {
        this.setWorkState(new StopState());
    }

    @Override
    public void manage(SupervisedWorker worker) {
        if (worker == null) {
            throw new IllegalArgumentException("worker required in Boss.manage");
        }
        worker.setSupervisor(this);
        this.workers.add(worker);
    }

    @Override
    public WorkQueue getWorkQueue() {
        return this.workQueue;
    }

    @Override
    public void setWorkState(WorkState workState) {
        this.workState = workState;
        SupervisedWorker worker2 = null;
        for (SupervisedWorker worker2 : this.workers) {
            workState.advise(worker2);
        }
        Thread workerThread = null;
        for (SupervisedWorker worker2 : this.workers) {
            workerThread = worker2.getThread();
            if (workerThread == null) continue;
            try {
                workerThread.join();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void setSupervisor(Supervisor supervisor) {
    }

    @Override
    public Supervisor getSupervisor() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    @Override
    public Thread getThread() {
        return Thread.currentThread();
    }

    public void setWorkQueue(WorkQueue workQueue) {
        if (workQueue == null) {
            throw new IllegalArgumentException("workQueue required in Boss.setWorkQueue");
        }
        this.workQueue = workQueue;
    }

    @Override
    public void run() {
    }

    @Override
    public WorkState getWorkState() {
        return this.workState;
    }
}

