/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.data;

import java.io.Serializable;
import nyla.solutions.core.security.data.Permission;

public class RegExpPermission
implements Permission,
Serializable {
    private static final long serialVersionUID = -2130916801947682213L;
    private final String regExp;

    public RegExpPermission(String regExp) {
        if (regExp == null || regExp.length() == 0) {
            throw new IllegalArgumentException("regExp is required");
        }
        this.regExp = regExp;
    }

    @Override
    public boolean isAuthorized(Permission permission) {
        if (permission == null) {
            return false;
        }
        String text = permission.getText();
        if (text == null) {
            return false;
        }
        return text.matches(this.regExp);
    }

    @Override
    public String getText() {
        return this.regExp;
    }
}

