/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.data;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import nyla.solutions.core.patterns.expression.BooleanExpression;

public class SecurityGroup
implements Group,
Serializable,
BooleanExpression<Principal> {
    private Set<Principal> groupMembers = new HashSet<Principal>();
    private final String name;
    static final long serialVersionUID = 1L;

    public SecurityGroup(String aGroupName) {
        if (aGroupName != null) {
            aGroupName = aGroupName.trim().toUpperCase();
        }
        this.name = aGroupName;
    }

    public boolean addMember(Principal principal) {
        if (this.groupMembers.contains(principal)) {
            return false;
        }
        this.groupMembers.add(principal);
        return true;
    }

    public boolean removeMember(Principal principal) {
        return this.groupMembers.remove(principal);
    }

    public Enumeration<Principal> members() {
        return Collections.enumeration(this.groupMembers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Group.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Group other = (Group)obj;
        return this.name.equals(other.getName());
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean isMember(Principal principal) {
        if (this.groupMembers.contains(principal)) {
            return true;
        }
        Vector<Principal> vector = new Vector<Principal>(10);
        return this.isMemberRecurse(principal, vector);
    }

    public String getName() {
        return this.name;
    }

    private boolean isMemberRecurse(Principal principal, Vector<Principal> vector) {
        Enumeration<Principal> enumeration = this.members();
        while (enumeration.hasMoreElements()) {
            Group group1;
            boolean flag = false;
            Principal principal1 = enumeration.nextElement();
            if (principal1.equals(principal)) {
                return true;
            }
            if (principal1 instanceof SecurityGroup) {
                SecurityGroup groupimpl = (SecurityGroup)((Object)principal1);
                vector.addElement((Principal)((Object)this));
                if (!vector.contains(groupimpl)) {
                    flag = groupimpl.isMemberRecurse(principal, vector);
                }
            } else if (principal1 instanceof Group && !vector.contains(group1 = (Group)principal1)) {
                flag = group1.isMember(principal);
            }
            if (!flag) continue;
            return flag;
        }
        return false;
    }

    @Override
    public Boolean apply(Principal obj) {
        if (this == obj) {
            return Boolean.TRUE;
        }
        if (obj == null) {
            return Boolean.FALSE;
        }
        if (!Group.class.isAssignableFrom(obj.getClass())) {
            return Boolean.FALSE;
        }
        Group other = (Group)obj;
        return this.name.equals(other.getName());
    }
}

