/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.data;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Set;
import nyla.solutions.core.patterns.expression.BooleanExpression;

public class SecurityUser
implements Principal,
Serializable,
BooleanExpression<Principal> {
    private static final long serialVersionUID = 5904346274735822066L;
    private Set<Group> groups = new HashSet<Group>();
    private String name;

    public SecurityUser() {
    }

    public SecurityUser(String name) {
        this(name, null);
    }

    public SecurityUser(String name, Set<Group> groups) {
        this.setName(name);
        this.setGroups(groups);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = name.trim().toUpperCase();
        }
        this.name = name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!SecurityUser.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        SecurityUser other = (SecurityUser)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SecurityUser [groups=").append(this.groups).append(", name=").append(this.name).append("]");
        return builder.toString();
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public Set<Group> getGroups() {
        if (this.groups.isEmpty()) {
            return null;
        }
        return new HashSet<Group>(this.groups);
    }

    public void setGroups(Set<Group> groups) {
        if (groups == null) {
            this.groups.clear();
        } else {
            this.groups = new HashSet<Group>(groups);
        }
    }

    @Override
    public Boolean apply(Principal obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!SecurityUser.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        SecurityUser other = (SecurityUser)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return true;
    }
}

