/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.user.conversion;

import java.io.File;
import java.io.IOException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.security.user.conversion.VcfStringToUserProfileConverter;
import nyla.solutions.core.security.user.data.UserProfile;

public class VcfFileToUserProfileConverter
implements Converter<File, UserProfile> {
    private VcfStringToUserProfileConverter converter = new VcfStringToUserProfileConverter();

    @Override
    public UserProfile convert(File file) {
        if (file == null) {
            return null;
        }
        try {
            String text = IO.readFile(file);
            if (text == null || text.length() == 0) {
                return null;
            }
            return this.converter.convert(text);
        }
        catch (IOException e) {
            throw new SystemException("Unable to convert file:" + file.getAbsolutePath() + " to user profile ERROR:" + e.getMessage(), e);
        }
    }

    public void setUserProfileClass(Class<? extends UserProfile> userProfileClass) {
        this.converter.setUserProfileClass(userProfileClass);
    }
}

