/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class Cryption {
    public static final String DEFAULT_ALGORITHM = Config.getProperty(Cryption.class, "algorithm", "AES");
    public static final String CRYPTION_PREFIX = "{cryption}";
    public static final String MIN_KEY_BYTE_SIZE_PROP = "security.cryption.min.key.byte.size";
    public static final String CRYPTION_KEY_PROP = "CRYPTION_KEY";
    private final Cipher decryptCipher;
    private final Cipher encryptCipher;
    private final String algorithm;
    private static Cryption canonical = null;

    public Cryption() {
        this.algorithm = DEFAULT_ALGORITHM;
        int minKeySize = Config.getPropertyInteger(MIN_KEY_BYTE_SIZE_PROP, 8);
        String keyText = Cryption.getCryptionKey();
        byte[] keyBytes = Arrays.copyOf(keyText.getBytes(StandardCharsets.UTF_8), 16);
        if (keyBytes.length < minKeySize) {
            throw new IllegalArgumentException("Minimum property byte size CRYPTION_KEY_PROP size is " + minKeySize);
        }
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, this.algorithm);
            this.encryptCipher = Cipher.getInstance(this.algorithm);
            this.encryptCipher.init(1, skeySpec);
            this.decryptCipher = Cipher.getInstance(this.algorithm);
            this.decryptCipher.init(2, skeySpec);
        }
        catch (Exception e) {
            throw new SetupException(Debugger.stackTrace(e));
        }
    }

    public static String getCryptionKey() {
        return Config.getProperty(CRYPTION_KEY_PROP);
    }

    public Cryption(byte[] keyBytes, String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm");
        }
        this.algorithm = algorithm;
        int minKeySize = Config.getPropertyInteger(MIN_KEY_BYTE_SIZE_PROP, 8);
        if (keyBytes.length < minKeySize) {
            throw new IllegalArgumentException("Minum key size is " + minKeySize);
        }
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, algorithm);
            this.encryptCipher = Cipher.getInstance(algorithm);
            this.encryptCipher.init(1, skeySpec);
            this.decryptCipher = Cipher.getInstance(algorithm);
            this.decryptCipher.init(2, skeySpec);
        }
        catch (Exception e) {
            throw new SetupException(Debugger.stackTrace(e));
        }
    }

    public byte[] encrypt(byte[] bytes) {
        try {
            return this.encryptCipher.doFinal(bytes);
        }
        catch (IllegalBlockSizeException e) {
            throw new SystemException(e);
        }
        catch (BadPaddingException e) {
            throw new SystemException(e);
        }
    }

    public String encryptText(String text) throws Exception {
        return this.toByteText(this.encrypt(text.getBytes(IO.CHARSET)));
    }

    public String decryptText(String text) throws Exception {
        return new String(this.decrypt(Cryption.toBytesFromByteText(text)), IO.CHARSET);
    }

    public byte[] decrypt(byte[] encryptBytes) throws Exception {
        try {
            return this.decryptCipher.doFinal(encryptBytes);
        }
        catch (IllegalBlockSizeException e) {
            throw new SystemException(e);
        }
        catch (BadPaddingException e) {
            throw new SystemException(e);
        }
    }

    public static boolean isEncrypted(char[] text) {
        if (text == null) {
            return false;
        }
        return Cryption.isEncrypted(new String(text));
    }

    public static boolean isEncrypted(String text) {
        return text != null && text.startsWith(CRYPTION_PREFIX);
    }

    public static String interpret(String text) {
        if (text == null) {
            return null;
        }
        if (Cryption.isEncrypted(text)) {
            try {
                text = text.substring(CRYPTION_PREFIX.length());
                text = Cryption.getCanonical().decryptText(text);
            }
            catch (Exception e) {
                throw new ConfigException("Cannot interpret:" + text, e);
            }
        }
        return text;
    }

    private static Cryption getCanonical() {
        if (canonical == null) {
            canonical = new Cryption();
        }
        return canonical;
    }

    public static char[] interpret(char[] text) {
        if (text == null) {
            throw new RequiredException("text");
        }
        return Cryption.interpret(String.valueOf(text)).toCharArray();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.err.println("Usage java " + Cryption.class.getName() + " <text>");
                return;
            }
            if (args[0].equals("-d")) {
                String decryptedPassword;
                if (args.length > 2) {
                    StringBuilder p = new StringBuilder();
                    for (int i = 1; i < args.length; ++i) {
                        if (i > 1) {
                            p.append(' ');
                        }
                        p.append(args[i]);
                    }
                    decryptedPassword = p.toString();
                } else {
                    decryptedPassword = args[1];
                }
                System.out.println(Cryption.getCanonical().decryptText(decryptedPassword));
            } else {
                System.out.println(CRYPTION_PREFIX + Cryption.getCanonical().encryptText(args[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    private String toByteText(byte[] aByte) {
        if (aByte == null) {
            return "";
        }
        return Base64.getEncoder().encodeToString(aByte);
    }

    private static byte[] toBytesFromByteText(String aByteText) {
        return Base64.getDecoder().decode(aByteText);
    }
}

