/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import nyla.solutions.core.exception.FormatException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.conversion.PropertyConverter;
import nyla.solutions.core.patterns.reflection.JavaBeanVisitor;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Organizer;
import nyla.solutions.core.util.Text;

public class JavaBean {
    public static <T> T newBean(Map<?, ?> aValues, Class<?> aClass) throws InstantiationException, IllegalAccessException {
        return JavaBean.newBean(aValues, aClass, null);
    }

    public static <T> T newBean(Map<?, ?> aValues, Class<?> aClass, PropertyConverter<Object, Object> convert) throws InstantiationException, IllegalAccessException {
        Object obj = ClassPath.newInstance(aClass);
        JavaBean.populate(aValues, obj, convert);
        return obj;
    }

    public static void populate(Map<?, ?> values, Object bean) {
        JavaBean.populate(values, bean, null);
    }

    public static void populate(Map<?, ?> aValues, Object bean, PropertyConverter<Object, Object> valueConverter) {
        Object key = null;
        try {
            for (Map.Entry<?, ?> entry : aValues.entrySet()) {
                key = entry.getKey();
                Object keyValue = entry.getValue();
                PropertyDescriptor desc = JavaBean.getPropertyDescriptor(bean, String.valueOf(key));
                if (desc == null || desc.getWriteMethod() == null) continue;
                if (valueConverter != null) {
                    Class<?> aClass = desc.getPropertyType();
                    keyValue = valueConverter.convert(keyValue, aClass);
                }
                Method invoke = desc.getWriteMethod();
                invoke.invoke(bean, keyValue);
            }
        }
        catch (Exception e) {
            throw new FormatException(e.getMessage() + " values:" + aValues, e);
        }
    }

    public static void acceptVisitor(Object bean, JavaBeanVisitor visitor) {
        if (bean == null) {
            return;
        }
        Class<?> beanClass = bean.getClass();
        if (ClassPath.isPrimitive(beanClass)) {
            visitor.visitClass(beanClass, bean);
            return;
        }
        PropertyDescriptor[] descriptors = JavaBean.getPropertyDescriptors(bean);
        Object value = null;
        for (int i = 0; i < descriptors.length; ++i) {
            String name = descriptors[i].getName();
            if ("class".equals(name)) {
                visitor.visitClass((Class)JavaBean.getProperty(bean, name), bean);
                continue;
            }
            if (descriptors[i].getReadMethod() == null) continue;
            value = JavaBean.getProperty(bean, name);
            visitor.visitProperty(name, value, bean);
        }
    }

    public static void setProperty(Object aBean, String aPropName, Object aValue) {
        try {
            PropertyDescriptor propertyDescriptor = JavaBean.getPropertyDescriptor(aBean, aPropName);
            propertyDescriptor.getWriteMethod().invoke(aBean, aValue);
        }
        catch (IllegalArgumentException e) {
            if (!(aValue instanceof String)) {
                throw e;
            }
            try {
                PropertyDescriptor desc = JavaBean.getPropertyDescriptor(aBean, aPropName);
                String text = (String)aValue;
                aValue = Text.toObject(text, desc.getPropertyType().getName());
                PropertyDescriptor propertyDescriptor = JavaBean.getPropertyDescriptor(aBean, aPropName);
                propertyDescriptor.getWriteMethod().invoke(aBean, aValue);
            }
            catch (Exception innerError) {
                throw e;
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Object key = Organizer.findByTextIgnoreCase(JavaBean.keySet(aBean), aPropName);
                PropertyDescriptor propertyDescriptor = JavaBean.getPropertyDescriptor(aBean, String.valueOf(key));
                propertyDescriptor.getWriteMethod().invoke(aBean, aValue);
            }
            catch (Exception e1) {
                String typeName = "null";
                if (aValue != null) {
                    typeName = aValue.getClass().getName();
                }
                throw new SystemException("type=" + typeName + " " + Debugger.toString(e));
            }
        }
        catch (Exception e) {
            String typeName = "null";
            if (aValue != null) {
                typeName = aValue.getClass().getName();
            }
            throw new SystemException("type=" + typeName + " " + e.getMessage(), e);
        }
    }

    public static Set<Object> keySet(Object aBean) {
        if (aBean == null) {
            return new HashSet<Object>();
        }
        Map<Object, Object> beanMap = JavaBean.toMap(aBean);
        return beanMap.keySet();
    }

    public static Map<Object, Object> toMap(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (ClassPath.isPrimitive(bean.getClass())) {
            HashMap<Object, Object> wrapMap = new HashMap<Object, Object>();
            wrapMap.put(bean, null);
            return wrapMap;
        }
        HashMap<Object, Object> description = new HashMap<Object, Object>();
        PropertyDescriptor[] descriptors = JavaBean.getPropertyDescriptors(bean);
        String value = null;
        for (int i = 0; i < descriptors.length; ++i) {
            String name = descriptors[i].getName();
            if ("class".equals(name) || descriptors[i].getReadMethod() == null) continue;
            value = (String)JavaBean.getProperty(bean, name);
            if (value == null) {
                value = "";
            }
            description.put(name, value);
        }
        return description;
    }

    public static Map<?, ?> toNestedMap(Object bean) throws Exception {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> description = new HashMap<String, Object>();
        PropertyDescriptor[] descriptors = JavaBean.getPropertyDescriptors(bean);
        Object value = null;
        for (int i = 0; i < descriptors.length; ++i) {
            String name = descriptors[i].getName();
            if ("class".equals(name) || descriptors[i].getReadMethod() == null) continue;
            value = JavaBean.getProperty(bean, name);
            if (JavaBean.isSimple(value)) {
                description.put(name, value);
                continue;
            }
            if (value instanceof Collection) {
                description.put(name, JavaBean.toCollectionMap((Collection)value));
                continue;
            }
            description.put(name, JavaBean.toNestedMap(value));
        }
        return description;
    }

    public static Collection<Object> toCollectionMap(Collection<?> aCollection) throws Exception {
        if (aCollection == null) {
            return null;
        }
        ArrayList<Object> listMap = new ArrayList<Object>(aCollection.size());
        Object nestedObj2 = null;
        for (Object nestedObj2 : aCollection) {
            listMap.add(JavaBean.toNestedMap(nestedObj2));
        }
        return listMap;
    }

    public static boolean isSimple(Object aObject) {
        if (aObject == null || aObject.getClass() == null || aObject.getClass().getName() == null) {
            return true;
        }
        return aObject instanceof Date || aObject instanceof Number || aObject instanceof String || aObject instanceof Character || aObject instanceof StringBuffer || aObject.getClass().getName().indexOf("java.lang") > -1;
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return JavaBean.getPropertyDescriptors(bean.getClass());
    }

    public static <T> T getProperty(Object bean, String name) throws SystemException {
        try {
            return (T)JavaBean.getNestedProperty(bean, name);
        }
        catch (Exception e) {
            throw new SystemException("Get property \"" + name + "\" ERROR:" + e.getMessage(), e);
        }
    }

    public static Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        int indexOfMAPPED_DELIM;
        int indexOfINDEXED_DELIM;
        block5: {
            if (bean == null) {
                return null;
            }
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("name required");
            }
            if (Collection.class.isAssignableFrom(bean.getClass())) {
                return JavaBean.getCollectionProperties((Collection)bean, name);
            }
            indexOfINDEXED_DELIM = -1;
            indexOfMAPPED_DELIM = -1;
            int indexOfMAPPED_DELIM2 = -1;
            int indexOfNESTED_DELIM = -1;
            do {
                indexOfNESTED_DELIM = name.indexOf(46);
                indexOfMAPPED_DELIM = name.indexOf(40);
                indexOfMAPPED_DELIM2 = name.indexOf(41);
                indexOfNESTED_DELIM = indexOfMAPPED_DELIM2 >= 0 && indexOfMAPPED_DELIM >= 0 && (indexOfNESTED_DELIM < 0 || indexOfNESTED_DELIM > indexOfMAPPED_DELIM) ? name.indexOf(46, indexOfMAPPED_DELIM2) : name.indexOf(46);
                if (indexOfNESTED_DELIM < 0) break block5;
                String next = name.substring(0, indexOfNESTED_DELIM);
                indexOfINDEXED_DELIM = next.indexOf(91);
                indexOfMAPPED_DELIM = next.indexOf(40);
                if ((bean = bean instanceof Map ? ((Map)bean).get(next) : (indexOfMAPPED_DELIM >= 0 ? JavaBean.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? JavaBean.getIndexedProperty(bean, next) : JavaBean.getSimpleProperty(bean, next)))) == null) {
                    return null;
                }
                name = name.substring(indexOfNESTED_DELIM + 1);
            } while (!Collection.class.isAssignableFrom(bean.getClass()));
            return JavaBean.getCollectionProperties((Collection)bean, name);
        }
        indexOfINDEXED_DELIM = name.indexOf(91);
        indexOfMAPPED_DELIM = name.indexOf(40);
        bean = bean instanceof Map ? ((Map)bean).get(name) : (indexOfMAPPED_DELIM >= 0 ? JavaBean.getMappedProperty(bean, name) : (indexOfINDEXED_DELIM >= 0 ? JavaBean.getIndexedProperty(bean, name) : JavaBean.getSimpleProperty(bean, name)));
        return bean;
    }

    public static Collection<Object> getCollectionProperties(Collection<?> collection, String name) throws Exception {
        if (collection == null) {
            throw new IllegalArgumentException("collection, name");
        }
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (Object bean : collection) {
            list.add(JavaBean.getNestedProperty(bean, name));
        }
        return list;
    }

    public static Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(40);
        int delim2 = name.indexOf(41);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "'");
        }
        String key = name.substring(delim + 1, delim2);
        name = name.substring(0, delim);
        return JavaBean.getMappedProperty(bean, name, key);
    }

    public static Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(91);
        int delim2 = name.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        int index = -1;
        try {
            String subscript = name.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        name = name.substring(0, delim);
        return JavaBean.getIndexedProperty(bean, name, index);
    }

    public static Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (name.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (name.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        PropertyDescriptor descriptor = JavaBean.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' in bean " + bean);
        }
        Method readMethod = JavaBean.getReadMethod(descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object value = readMethod.invoke(bean, new Object[0]);
        return value;
    }

    public static Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        try {
            if (bean == null) {
                throw new IllegalArgumentException("No bean specified");
            }
            if (name == null) {
                throw new IllegalArgumentException("No name specified");
            }
            PropertyDescriptor descriptor = JavaBean.getPropertyDescriptor(bean, name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'");
            }
            if (!(descriptor instanceof IndexedPropertyDescriptor)) {
                throw new Exception();
            }
            Method readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
            if (readMethod == null) {
                throw new Exception();
            }
            Object[] subscript = new Object[]{index};
            return readMethod.invoke(bean, subscript);
        }
        catch (Exception e) {
            if (e instanceof ArrayIndexOutOfBoundsException) {
                throw (ArrayIndexOutOfBoundsException)e;
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified");
        }
        Object result = null;
        PropertyDescriptor descriptor = JavaBean.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof JBPropertyDescriber) {
            Method readMethod = ((JBPropertyDescriber)descriptor).getMappedReadMethod();
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method");
            Object[] keyArray = new Object[]{key};
            return readMethod.invoke(bean, keyArray);
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method");
        Object invokeResult = readMethod.invoke(bean, new Object[0]);
        if (!(invokeResult instanceof Map)) return result;
        return ((Map)invokeResult).get(key);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        PropertyDescriptor[] descriptors;
        int period;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        while ((period = name.indexOf(46)) >= 0) {
            String next = name.substring(0, period);
            int indexOfINDEXED_DELIM = next.indexOf(91);
            int indexOfMAPPED_DELIM = next.indexOf(40);
            bean = indexOfMAPPED_DELIM >= 0 && (indexOfINDEXED_DELIM < 0 || indexOfMAPPED_DELIM < indexOfINDEXED_DELIM) ? JavaBean.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? JavaBean.getIndexedProperty(bean, next) : JavaBean.getSimpleProperty(bean, next));
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, period) + "'");
            }
            name = name.substring(period + 1);
        }
        int left = name.indexOf(91);
        if (left >= 0) {
            name = name.substring(0, left);
        }
        if ((left = name.indexOf(40)) >= 0) {
            name = name.substring(0, left);
        }
        if ((descriptors = JavaBean.getPropertyDescriptors(bean)) != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                return descriptors[i];
            }
        }
        JBPropertyDescriber result = null;
        try {
            result = new JBPropertyDescriber(name, bean.getClass());
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return result;
    }

    private static Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodAdapter.getAccessibleMethod(descriptor.getReadMethod());
    }

    protected static class JBPropertyDescriber
    extends PropertyDescriptor {
        private Class<?> mappedPropertyType;
        private Method mappedReadMethod;
        private Method mappedWriteMethod;
        private static final Class<?>[] stringClassArray;
        private static Hashtable<Object, Object> declaredMethodCache;

        public JBPropertyDescriber(String propertyName, Class<?> beanClass) throws IntrospectionException {
            super(propertyName, null, null);
            if (propertyName == null || propertyName.length() == 0) {
                throw new IntrospectionException("bad property name: " + propertyName + " on class: " + beanClass.getClass().getName());
            }
            this.setName(propertyName);
            String base = JBPropertyDescriber.capitalizePropertyName(propertyName);
            try {
                this.mappedReadMethod = JBPropertyDescriber.findMethod(beanClass, "get" + base, 1, stringClassArray);
                Class[] params = new Class[]{String.class, this.mappedReadMethod.getReturnType()};
                this.mappedWriteMethod = JBPropertyDescriber.findMethod(beanClass, "set" + base, 2, params);
            }
            catch (IntrospectionException e) {
                Debugger.println(e.getMessage());
            }
            if (this.mappedReadMethod == null) {
                this.mappedWriteMethod = JBPropertyDescriber.findMethod(beanClass, "set" + base, 2);
            }
            if (this.mappedReadMethod == null && this.mappedWriteMethod == null) {
                throw new IntrospectionException("Property '" + propertyName + "' not found on " + beanClass.getName());
            }
            this.findMappedPropertyType();
        }

        public JBPropertyDescriber(String propertyName, Class<?> beanClass, String mappedGetterName, String mappedSetterName) throws IntrospectionException {
            super(propertyName, null, null);
            if (propertyName == null || propertyName.length() == 0) {
                throw new IntrospectionException("bad property name: " + propertyName);
            }
            this.setName(propertyName);
            this.mappedReadMethod = JBPropertyDescriber.findMethod(beanClass, mappedGetterName, 1, stringClassArray);
            if (this.mappedReadMethod != null) {
                Class[] params = new Class[]{String.class, this.mappedReadMethod.getReturnType()};
                this.mappedWriteMethod = JBPropertyDescriber.findMethod(beanClass, mappedSetterName, 2, params);
            } else {
                this.mappedWriteMethod = JBPropertyDescriber.findMethod(beanClass, mappedSetterName, 2);
            }
            this.findMappedPropertyType();
        }

        public JBPropertyDescriber(String propertyName, Method mappedGetter, Method mappedSetter) throws IntrospectionException {
            super(propertyName, mappedGetter, mappedSetter);
            if (propertyName == null || propertyName.length() == 0) {
                throw new IntrospectionException("bad property name: " + propertyName);
            }
            this.setName(propertyName);
            this.mappedReadMethod = mappedGetter;
            this.mappedWriteMethod = mappedSetter;
            this.findMappedPropertyType();
        }

        public Class<?> getMappedPropertyType() {
            return this.mappedPropertyType;
        }

        public Method getMappedReadMethod() {
            return this.mappedReadMethod;
        }

        public void setMappedReadMethod(Method mappedGetter) throws IntrospectionException {
            this.mappedReadMethod = mappedGetter;
            this.findMappedPropertyType();
        }

        public Method getMappedWriteMethod() {
            return this.mappedWriteMethod;
        }

        public void setMappedWriteMethod(Method mappedSetter) throws IntrospectionException {
            this.mappedWriteMethod = mappedSetter;
            this.findMappedPropertyType();
        }

        private void findMappedPropertyType() throws IntrospectionException {
            this.mappedPropertyType = null;
            if (this.mappedReadMethod != null) {
                if (this.mappedReadMethod.getParameterTypes().length != 1) {
                    throw new IntrospectionException("bad mapped read method arg count");
                }
                this.mappedPropertyType = this.mappedReadMethod.getReturnType();
                if (this.mappedPropertyType == Void.TYPE) {
                    throw new IntrospectionException("mapped read method " + this.mappedReadMethod.getName() + " returns void");
                }
            }
            if (this.mappedWriteMethod != null) {
                Class<?>[] params = this.mappedWriteMethod.getParameterTypes();
                if (params.length != 2) {
                    throw new IntrospectionException("bad mapped write method arg count");
                }
                if (this.mappedPropertyType != null && this.mappedPropertyType != params[1]) {
                    throw new IntrospectionException("type mismatch between mapped read and write methods");
                }
                this.mappedPropertyType = params[1];
            }
        }

        private static String capitalizePropertyName(String s) {
            if (s.length() == 0) {
                return s;
            }
            char[] chars = s.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }

        private static synchronized Method[] getPublicDeclaredMethods(Class<?> clz) {
            final Class<?> fclz = clz;
            Method[] result = (Method[])declaredMethodCache.get(fclz);
            if (result != null) {
                return result;
            }
            result = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return fclz.getDeclaredMethods();
                }
            });
            for (int i = 0; i < result.length; ++i) {
                Method method = result[i];
                int mods = method.getModifiers();
                if (Modifier.isPublic(mods)) continue;
                result[i] = null;
            }
            declaredMethodCache.put(clz, result);
            return result;
        }

        private static Method internalFindMethod(Class<?> start, String methodName, int argCount) {
            for (Class<?> cl = start; cl != null; cl = cl.getSuperclass()) {
                Method[] methods = JBPropertyDescriber.getPublicDeclaredMethods(cl);
                for (int i = 0; i < methods.length; ++i) {
                    int mods;
                    Method method = methods[i];
                    if (method == null || Modifier.isStatic(mods = method.getModifiers()) || !method.getName().equals(methodName) || method.getParameterTypes().length != argCount) continue;
                    return method;
                }
            }
            Class<?>[] ifcs = start.getInterfaces();
            for (int i = 0; i < ifcs.length; ++i) {
                Method m = JBPropertyDescriber.internalFindMethod(ifcs[i], methodName, argCount);
                if (m == null) continue;
                return m;
            }
            return null;
        }

        private static Method internalFindMethod(Class<?> start, String methodName, int argCount, Class<?>[] args) {
            for (Class<?> cl = start; cl != null; cl = cl.getSuperclass()) {
                Method[] methods = JBPropertyDescriber.getPublicDeclaredMethods(cl);
                for (int i = 0; i < methods.length; ++i) {
                    int mods;
                    Method method = methods[i];
                    if (method == null || Modifier.isStatic(mods = method.getModifiers())) continue;
                    Class<?>[] params = method.getParameterTypes();
                    if (!method.getName().equals(methodName) || params.length != argCount) continue;
                    boolean different = false;
                    if (argCount > 0) {
                        for (int j = 0; j < argCount; ++j) {
                            if (params[j] == args[j]) continue;
                            different = true;
                        }
                        if (different) continue;
                    }
                    return method;
                }
            }
            Class<?>[] ifcs = start.getInterfaces();
            for (int i = 0; i < ifcs.length; ++i) {
                Method m = JBPropertyDescriber.internalFindMethod(ifcs[i], methodName, argCount);
                if (m == null) continue;
                return m;
            }
            return null;
        }

        static Method findMethod(Class<?> cls, String methodName, int argCount) throws IntrospectionException {
            if (methodName == null) {
                return null;
            }
            Method m = JBPropertyDescriber.internalFindMethod(cls, methodName, argCount);
            if (m != null) {
                return m;
            }
            throw new IntrospectionException("No method \"" + methodName + "\" with " + argCount + " arg(s)");
        }

        static Method findMethod(Class<?> cls, String methodName, int argCount, Class<?>[] args) throws IntrospectionException {
            if (methodName == null) {
                return null;
            }
            Method m = JBPropertyDescriber.internalFindMethod(cls, methodName, argCount, args);
            if (m != null) {
                return m;
            }
            throw new IntrospectionException("No method \"" + methodName + "\" with " + argCount + " arg(s) of matching types.");
        }

        static boolean isSubclass(Class<?> a, Class<?> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            for (Class<?> x = a; x != null; x = x.getSuperclass()) {
                if (x == b) {
                    return true;
                }
                if (!b.isInterface()) continue;
                Class<?>[] interfaces = x.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!JBPropertyDescriber.isSubclass(interfaces[i], b)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mappedPropertyType == null ? 0 : this.mappedPropertyType.hashCode());
            result = 31 * result + (this.mappedReadMethod == null ? 0 : this.mappedReadMethod.hashCode());
            result = 31 * result + (this.mappedWriteMethod == null ? 0 : this.mappedWriteMethod.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JBPropertyDescriber other = (JBPropertyDescriber)obj;
            if (this.mappedPropertyType == null ? other.mappedPropertyType != null : !this.mappedPropertyType.equals(other.mappedPropertyType)) {
                return false;
            }
            if (this.mappedReadMethod == null ? other.mappedReadMethod != null : !this.mappedReadMethod.equals(other.mappedReadMethod)) {
                return false;
            }
            return !(this.mappedWriteMethod == null ? other.mappedWriteMethod != null : !this.mappedWriteMethod.equals(other.mappedWriteMethod));
        }

        static {
            declaredMethodCache = new Hashtable();
            stringClassArray = new Class[]{String.class};
        }
    }

    protected static class MethodAdapter {
        private static final Class<?>[] emptyClassArray = new Class[0];
        private static final Object[] emptyObjectArray = new Object[0];

        public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
            Object[] args = new Object[]{arg};
            return MethodAdapter.invokeMethod(object, methodName, args);
        }

        public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
            if (args == null) {
                args = emptyObjectArray;
            }
            int arguments = args.length;
            Class[] parameterTypes = new Class[arguments];
            for (int i = 0; i < arguments; ++i) {
                parameterTypes[i] = args[i].getClass();
            }
            return MethodAdapter.invokeMethod(object, methodName, args, parameterTypes);
        }

        public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
            if (parameterTypes == null) {
                parameterTypes = emptyClassArray;
            }
            if (args == null) {
                args = emptyObjectArray;
            }
            Method method = MethodAdapter.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes);
            return method.invoke(object, args);
        }

        public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Object[] args = new Object[]{arg};
            return MethodAdapter.invokeExactMethod(object, methodName, args);
        }

        public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            if (args == null) {
                args = emptyObjectArray;
            }
            int arguments = args.length;
            Class[] parameterTypes = new Class[arguments];
            for (int i = 0; i < arguments; ++i) {
                parameterTypes[i] = args[i].getClass();
            }
            return MethodAdapter.invokeExactMethod(object, methodName, args, parameterTypes);
        }

        public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Method method;
            if (args == null) {
                args = emptyObjectArray;
            }
            if (parameterTypes == null) {
                parameterTypes = emptyClassArray;
            }
            if ((method = MethodAdapter.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
                throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
            }
            return method.invoke(object, args);
        }

        public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?> parameterType) throws NoSuchMethodException {
            Class[] parameterTypes = new Class[]{parameterType};
            return MethodAdapter.getAccessibleMethod(clazz, methodName, parameterTypes);
        }

        public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
            return MethodAdapter.getAccessibleMethod(clazz.getMethod(methodName, parameterTypes));
        }

        public static Method getAccessibleMethod(Method method) {
            if (method == null) {
                return null;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return null;
            }
            Class<?> clazz = method.getDeclaringClass();
            if (Modifier.isPublic(clazz.getModifiers())) {
                return method;
            }
            method = MethodAdapter.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
            return method;
        }

        private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
            Method method = null;
            while (clazz != null) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException e) {
                        Debugger.println(e.getMessage());
                    }
                    if (method != null || (method = MethodAdapter.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                clazz = clazz.getSuperclass();
            }
            if (method != null) {
                return method;
            }
            return null;
        }

        public static Method getMatchingAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws Exception {
            Method method = clazz.getMethod(methodName, parameterTypes);
            try {
                method.setAccessible(true);
            }
            catch (SecurityException se) {
                se.printStackTrace();
            }
            return method;
        }

        protected static final boolean isAssignmentCompatible(Class<?> parameterType, Class<?> parameterization) {
            if (parameterType.isAssignableFrom(parameterization)) {
                return true;
            }
            if (parameterType.isPrimitive()) {
                if (Boolean.TYPE.equals(parameterType)) {
                    return Boolean.class.equals(parameterization);
                }
                if (Float.TYPE.equals(parameterType)) {
                    return Float.class.equals(parameterization);
                }
                if (Long.TYPE.equals(parameterType)) {
                    return Long.class.equals(parameterization);
                }
                if (Integer.TYPE.equals(parameterType)) {
                    return Integer.class.equals(parameterization);
                }
                if (Double.TYPE.equals(parameterType)) {
                    return Double.class.equals(parameterization);
                }
            }
            return false;
        }
    }
}

