/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import nyla.solutions.core.data.clock.Day;
import nyla.solutions.core.data.clock.Time;
import nyla.solutions.core.data.clock.TimeInterval;
import nyla.solutions.core.data.clock.TimeSlot;

public class Scheduler {
    public static final String DATE_FORMAT = "mm/dd/yyyy";
    private Timer timer = new Timer();

    public static Calendar toCalendar(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        return calendar;
    }

    public static Date toDateAddDaysSetOfWeek(int days, int dayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, days);
        return cal.getTime();
    }

    public static Date toDateDayOfWeek(int dayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, dayOfWeek);
        return cal.getTime();
    }

    public static long durationMS(Date start, Date end) {
        if (start == null || end == null) {
            return 0L;
        }
        return end.getTime() - start.getTime();
    }

    public static double durationSeconds(Date start, Date end) {
        return (double)Scheduler.durationMS(start, end) * 0.001;
    }

    public static double durationMinutes(Date start, Date end) {
        return Scheduler.durationSeconds(start, end) / 60.0;
    }

    public static double durationHours(Date start, Date end) {
        return Scheduler.durationMinutes(start, end) / 60.0;
    }

    public static Collection<TimeSlot> calculateAvailableSots(Collection<TimeInterval> takenTimeSlots, Date date, int intervalSeconds, Time startTime, Time endTime) {
        Day day = new Day(date);
        Collection<TimeSlot> allTimeSlots = Scheduler.calculateTimeSots(day, intervalSeconds, startTime, endTime);
        if (takenTimeSlots == null || takenTimeSlots.isEmpty()) {
            return allTimeSlots;
        }
        TimeSlot timeSlot2 = null;
        TreeSet<TimeSlot> availableSlots = new TreeSet<TimeSlot>();
        for (TimeSlot timeSlot2 : allTimeSlots) {
            if (takenTimeSlots.contains(timeSlot2)) continue;
            availableSlots.add(timeSlot2);
        }
        return availableSlots;
    }

    public static Collection<TimeSlot> calculateTimeSots(Day day, int intervalSeconds, Time startTime, Time endTime) {
        TimeSlot startSlot;
        if (intervalSeconds < 1) {
            throw new IllegalArgumentException("interval seconds cannot be less than one");
        }
        int count = 86400 / intervalSeconds;
        ArrayList<TimeSlot> slots = new ArrayList<TimeSlot>(count);
        for (TimeSlot slot = startSlot = TimeSlot.firstSlot(day, startTime, intervalSeconds); slot != null; slot = slot.nextTimeSlot(intervalSeconds, endTime)) {
            slots.add(slot);
        }
        return slots;
    }

    public static Date toDate(Day day, Time time) {
        time.setDay(day);
        return time.getDate();
    }

    public void scheduleRecurring(Runnable runnable, Date firstTime, long period) {
        this.timer.scheduleAtFixedRate(Scheduler.toTimerTask(runnable), firstTime, period);
    }

    public int purgeSchedules() {
        return this.timer.purge();
    }

    public static TimerTask toTimerTask(Runnable runnable) {
        if (runnable instanceof TimerTask) {
            return (TimerTask)runnable;
        }
        return new TimerTaskRunnerAdapter(runnable);
    }

    private static class TimerTaskRunnerAdapter
    extends TimerTask {
        private Runnable runnable = null;

        TimerTaskRunnerAdapter(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

