/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.settings;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Text;
import nyla.solutions.core.util.settings.AbstractSettings;

public class ConfigSettings
extends AbstractSettings {
    private boolean mergeSystemProperties = true;
    private boolean mergeEnvProperties = true;
    private boolean setSystemProperties = false;
    private String configSourceLocation = null;
    private Properties properties = null;

    @Override
    public synchronized Map<Object, Object> getProperties() {
        if (this.properties == null || this.isAlwaysReload()) {
            this.loadProperties();
        }
        return new HashMap<Object, Object>(this.properties);
    }

    @Override
    public synchronized void setProperties(Map<Object, Object> properties) {
        this.properties = new Properties();
        this.properties.putAll(properties);
    }

    @Override
    public void reLoad() {
        this.loadProperties();
    }

    private synchronized void loadProperties() {
        try {
            String propName;
            String useFormattingText;
            String reloadBool;
            boolean alwaysReload = this.isAlwaysReload();
            boolean useFormatting = this.isUseFormatting();
            String file = this.getSystemPropertyFile();
            if (file != null && file.length() > 0) {
                try (FileInputStream fis = new FileInputStream(file);){
                    this.properties = new Properties();
                    this.properties.load(fis);
                    this.configSourceLocation = file;
                }
            }
            this.properties = new Properties();
            try {
                String bundleName = this.getBundleName();
                ResourceBundle rb = ResourceBundle.getBundle(bundleName);
                URL url = Config.class.getResource(bundleName + ".properties");
                this.configSourceLocation = url != null ? url.toString() : bundleName + ".properties";
                Enumeration<String> keys = rb.getKeys();
                Object var8_14 = null;
                while (keys.hasMoreElements()) {
                    String string = keys.nextElement();
                    this.properties.put(string, rb.getString(string + ""));
                }
            }
            catch (MissingResourceException bundleName) {
                // empty catch block
            }
            alwaysReload = (reloadBool = this.properties.getProperty(Config.class.getName() + ".alwaysReload")) == null || reloadBool.length() == 0 ? false : Boolean.valueOf(reloadBool);
            this.setAlwaysReload(alwaysReload);
            this.mergeSystemProperties = Boolean.valueOf(this.properties.getProperty(Config.class.getName() + ".mergeSystemProperties", "true"));
            if (this.mergeSystemProperties) {
                this.properties.putAll((Map<?, ?>)System.getProperties());
            }
            this.mergeEnvProperties = Boolean.valueOf(this.properties.getProperty(Config.class.getName() + ".mergeEnvProperties", "true"));
            if (this.mergeEnvProperties) {
                this.properties.putAll(System.getenv());
            }
            if (useFormatting = (useFormattingText = this.properties.getProperty(propName = Config.class.getName() + ".useFormatting")) == null || useFormattingText.length() == 0 ? false : Boolean.valueOf(useFormattingText)) {
                Text.formatMap(this.properties);
            }
            propName = Config.class.getName() + ".setSystemProperties";
            this.setSystemProperties = Boolean.valueOf(this.properties.getProperty(propName, "false"));
            if (this.setSystemProperties) {
                Set<Object> keySet = this.properties.keySet();
                for (String string : keySet) {
                    String sysProp = System.getProperty(string);
                    if (sysProp != null && sysProp.length() > 0) continue;
                    System.setProperty(string, this.properties.getProperty(string));
                }
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new ConfigException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ConfigException(e.getMessage(), e);
        }
    }

    private String getSystemPropertyFile() {
        String file = System.getProperty("config.properties");
        if (file == null || file.length() == 0) {
            // empty if block
        }
        return file;
    }

    @Override
    public String getLocation() {
        return this.configSourceLocation;
    }
}

