/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.clock;

import java.io.Serializable;
import java.util.Date;
import nyla.solutions.core.data.clock.Time;
import nyla.solutions.core.data.clock.TimeInterval;
import nyla.solutions.core.data.clock.TimeSlot;

public class Appointment
implements Serializable,
Comparable<Appointment> {
    private static final long serialVersionUID = 4865756250759427705L;
    private Date reminderDate = null;
    private String name = null;
    private TimeSlot timeSlot = null;
    private String location = null;

    public static Appointment getEvent(String name, int startHour24, int durationSeconds) {
        Appointment event = new Appointment();
        event.setName(name);
        Time time = new Time();
        time.setHour24(startHour24);
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.setStartDate(time.getLocalDateTime());
        time.addSeconds(durationSeconds);
        timeSlot.setEndDate(time.getLocalDateTime());
        event.setTimeSlot(timeSlot);
        return event;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeInterval getTimeSlot() {
        return this.timeSlot;
    }

    public void setTimeSlot(TimeSlot timeSlot) {
        this.timeSlot = timeSlot;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Date getReminderDate() {
        if (this.reminderDate == null) {
            return null;
        }
        return new Date(this.reminderDate.getTime());
    }

    public void setReminderDate(Date reminderDate) {
        this.reminderDate = reminderDate == null ? null : new Date(reminderDate.getTime());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.reminderDate == null ? 0 : this.reminderDate.hashCode());
        result = 31 * result + (this.timeSlot == null ? 0 : this.timeSlot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Appointment other = (Appointment)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.reminderDate == null ? other.reminderDate != null : !this.reminderDate.equals(other.reminderDate)) {
            return false;
        }
        return !(this.timeSlot == null ? other.timeSlot != null : !this.timeSlot.equals(other.timeSlot));
    }

    @Override
    public int compareTo(Appointment other) {
        return this.timeSlot.compareTo(other.timeSlot);
    }
}

