/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.ds;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.x500.X500Principal;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class ActiveDirectory {
    private String fullUrl = "";
    private String userDnPrefix = Config.getProperty(ActiveDirectory.class, "userDnPrefix", "");
    private String userDnSuffix = Config.getProperty(ActiveDirectory.class, "userDnSuffix", "");
    private String referralType = Config.getProperty(ActiveDirectory.class, "referralType", "follow");
    private String aliasType = Config.getProperty(ActiveDirectory.class, "aliasType", "searching");
    private String rootDn = Config.getProperty("LDAP_ROOT_DN");
    private boolean tracing = Config.getPropertyBoolean(ActiveDirectory.class, "tracing", false);
    private String serverUrl = Config.getProperty("LDAP_SERVER_URL");
    private static final String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";

    public ActiveDirectory() {
        this.fullUrl = this.serverUrl + "/" + this.rootDn;
        this.fullUrl = this.getValidURL(this.fullUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String username, char[] password) throws NamingException {
        Context ctx = null;
        try {
            String userDN = this.toDN(username);
            ctx = this.initContext(userDN, password);
            X500Principal x500Principal = new X500Principal(userDN);
            return x500Principal;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private DirContext initContext(String userDN, char[] password) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        this.setupBasicProperties(env);
        ActiveDirectory.setupSimpleSecurityProperties(env, userDN, password);
        return new InitialDirContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRoles(String username, char[] password) throws NamingException {
        String[] rolesArray = null;
        Context ctx = null;
        try {
            String userDN = this.toDN(username);
            ctx = this.initContext(userDN, password);
            SearchControls sc = new SearchControls();
            String[] attributeFilter = new String[]{"cn", "mail", "memberOf"};
            sc.setReturningAttributes(attributeFilter);
            sc.setSearchScope(2);
            String filter = "(&(sAMAccountName=" + username + "))";
            NamingEnumeration<SearchResult> results = ctx.search("", filter, sc);
            ArrayList<String> roles = new ArrayList<String>();
            while (results.hasMore()) {
                SearchResult sr = results.next();
                Attributes attrs = sr.getAttributes();
                Attribute attr2 = attrs.get("memberOf");
                NamingEnumeration<?> ne = attr2.getAll();
                while (ne.hasMore()) {
                    roles.add(ne.next().toString());
                }
                rolesArray = new String[roles.size()];
                roles.toArray(rolesArray);
            }
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception ex) {
                Debugger.printError(ex);
            }
        }
        return rolesArray;
    }

    private String toDN(String username) {
        String userDN = this.userDnPrefix + username + this.userDnSuffix;
        return userDN;
    }

    private String getValidURL(String url) {
        if (url != null && url.length() > 0) {
            return url.replaceAll("[%]", "%25").replaceAll(" ", "%20").replaceAll("[<]", "%3c").replaceAll("[>]", "%3e").replaceAll("[\"]", "%3f").replaceAll("[#]", "%23").replaceAll("[{]", "%7b").replaceAll("[}]", "%7d").replaceAll("[|]", "%7c").replaceAll("[\\\\]", "%5c").replaceAll("[\\^]", "%5e").replaceAll("[~]", "%7e").replaceAll("[\\[]", "%5b").replaceAll("[\\]]", "%5d").replaceAll("[']", "%27").replaceAll("[?]", "%3f");
        }
        return url;
    }

    private static void setupSimpleSecurityProperties(Hashtable<String, Object> env, String userDn, char[] pwd) {
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userDn);
        env.put("java.naming.security.credentials", new String(pwd));
    }

    private Hashtable<?, ?> setupBasicProperties(Hashtable<String, Object> env) throws NamingException {
        return this.setupBasicProperties(env, this.fullUrl);
    }

    private Hashtable<String, Object> setupBasicProperties(Hashtable<String, Object> env, String providerUrl) throws NamingException {
        if (this.tracing) {
            env.put("com.sun.jndi.ldap.trace.ber", System.err);
        }
        env.put("java.naming.ldap.version", "3");
        if (env.get("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", DEFAULT_CTX);
        }
        env.put("java.naming.ldap.deleteRDN", "false");
        env.put("java.naming.referral", this.referralType);
        env.put("java.naming.ldap.attributes.binary", "photo jpegphoto jpegPhoto");
        env.put("java.naming.ldap.derefAliases", this.aliasType);
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.provider.url", providerUrl);
        return env;
    }
}

