/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.operations;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.util.Debugger;

public class Shell {
    private final File workingDirectory;
    private final File log;
    private int defaultBackgroundReadSize = 20;
    private final HashMap<String, String> envMap = new HashMap();

    public Shell() {
        this((File)null, (File)null);
    }

    public Shell(String workingDirectory, File logFile) {
        this(Paths.get(workingDirectory, new String[0]).toFile(), logFile);
    }

    public Shell(String workingDirectory, String logFile) {
        this(Paths.get(workingDirectory, new String[0]).toFile(), Paths.get(logFile, new String[0]).toFile());
    }

    public Shell(File workingDirectory, File logFile) {
        this.log = logFile;
        this.workingDirectory = workingDirectory;
    }

    public ProcessInfo execute(List<String> commands) throws IOException {
        return this.execute(false, commands);
    }

    public ProcessInfo execute(boolean background, List<String> commands) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(commands);
        return this.executeProcess(background, pb);
    }

    public ProcessInfo execute(String ... command) {
        return this.execute(false, command);
    }

    public ProcessInfo execute(boolean background, String ... command) {
        ProcessBuilder pb = new ProcessBuilder(command);
        return this.executeProcess(background, pb);
    }

    private ProcessInfo executeProcess(boolean background, ProcessBuilder pb) {
        try {
            pb.directory(this.workingDirectory);
            pb.redirectErrorStream(false);
            if (this.log != null) {
                pb.redirectOutput(ProcessBuilder.Redirect.appendTo(this.log));
            }
            pb.environment().putAll(this.envMap);
            Process p = pb.start();
            String out = null;
            String error = null;
            if (background) {
                out = IO.readText(p.getInputStream(), true, this.defaultBackgroundReadSize);
                error = IO.readText(p.getErrorStream(), true, 20);
            } else {
                out = IO.readText(p.getInputStream(), true);
                error = IO.readText(p.getErrorStream(), true);
            }
            if (background) {
                return new ProcessInfo(0, out, error);
            }
            return new ProcessInfo(p.waitFor(), out, error);
        }
        catch (Exception e) {
            return new ProcessInfo(-1, null, Debugger.stackTrace(e));
        }
    }

    public int getDefaultBackgroundReadSize() {
        return this.defaultBackgroundReadSize;
    }

    public void setDefaultBackgroundReadSize(int defaultBackgroundReadSize) {
        this.defaultBackgroundReadSize = defaultBackgroundReadSize;
    }

    public void setEnvProperty(String key, String value) {
        this.envMap.put(key, value);
    }

    public String getEnvProperty(String key) {
        return this.envMap.get(key);
    }

    public static final class ProcessInfo {
        public final int exitValue;
        public final String output;
        public final String error;

        public ProcessInfo(int exitValue, String output, String error) {
            this.exitValue = exitValue;
            this.output = output;
            this.error = error;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ProcessInfo [exitValue=").append(this.exitValue).append(", output=").append(this.output).append(", error=").append(this.error).append("]");
            return builder.toString();
        }

        public boolean hasError() {
            return this.exitValue != 0 || this.error != null && this.error.length() > 0;
        }
    }
}

