/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.PROXY;

public class ObjectMethodProxy {
    private Method method = null;
    private Class<?>[] parameterTypes = null;
    private String methodName = null;
    private Object target = null;
    private Class<?> targetClass = null;

    public ObjectMethodProxy(Object target, String methodName) throws NoSuchMethodException {
        this(target, methodName, null);
    }

    public ObjectMethodProxy(Object target, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (target == null) {
            throw new RequiredException("target");
        }
        this.target = target;
        this.targetClass = this.target.getClass();
        this.methodName = methodName;
        this.parameterTypes = parameterTypes == null ? null : (Class[])parameterTypes.clone();
        if (this.parameterTypes != null) {
            this.method = this.targetClass.getDeclaredMethod(methodName, parameterTypes);
        }
    }

    public Object execute(Object[] arguments) throws Exception {
        try {
            if (this.method == null) {
                if (this.parameterTypes == null) {
                    this.parameterTypes = PROXY.toParameterTypes(arguments);
                }
                this.method = PROXY.findMethod(this.targetClass, this.methodName, this.parameterTypes);
            }
            return this.method.invoke(this.target, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.target.getClass().getName() + "." + this.method + "(" + Debugger.toString(e) + ")");
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    public static Method findMethod(Class<?> objClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return objClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (Object.class.equals(objClass)) {
                throw e;
            }
            return ObjectMethodProxy.findMethod(objClass.getSuperclass(), methodName, parameterTypes);
        }
    }
}

