/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.decorator;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import nyla.solutions.core.data.Mapped;
import nyla.solutions.core.data.Textable;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;

public class MappedTextFormatDecorator
implements Mapped<String, Textable>,
Textable {
    private String templateUrl = Config.getProperty(MappedTextFormatDecorator.class.getName() + ".templateUrl", "");
    private Map<String, Textable> map = new Hashtable<String, Textable>();
    private String template = Config.getProperty(MappedTextFormatDecorator.class.getName() + ".template", "");

    @Override
    public Map<String, Textable> getMap() {
        return this.map;
    }

    @Override
    public void setMap(Map<String, Textable> map) {
        if (map == null) {
            throw new RequiredException("map in MappedTextFormatDecorator.setMap");
        }
        this.map = map;
    }

    private String getTemplate() throws IOException {
        if (this.template != null && this.template.length() > 0) {
            return this.template;
        }
        if (this.templateUrl == null || this.templateUrl.length() == 0) {
            throw new RequiredException("templateUrl in MappedTextFormatDecorator.getText");
        }
        return IO.readURL(this.templateUrl);
    }

    @Override
    public String getText() {
        String key = null;
        try {
            String bindTemplate = this.getTemplate();
            Hashtable<String, String> textMap = new Hashtable<String, String>();
            for (Map.Entry<String, Textable> entry : this.map.entrySet()) {
                key = entry.getKey();
                try {
                    textMap.put(key, entry.getValue().getText());
                }
                catch (Exception e) {
                    throw new SystemException("Unable to build text for key:" + key + " error:" + e.getMessage(), e);
                }
            }
            Debugger.println(this, "bindTemplate=" + bindTemplate);
            String formattedOutput = Text.format(bindTemplate, textMap);
            Debugger.println(this, "formattedOutput=" + formattedOutput);
            return formattedOutput;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SetupException(e.getMessage(), e);
        }
    }

    public String getTemplateUrl() {
        return this.templateUrl;
    }

    public void setTemplateUrl(String templateUrl) {
        if (templateUrl == null || templateUrl.length() == 0) {
            throw new IllegalArgumentException("templateUrl required in setTemplateUrl");
        }
        this.templateUrl = templateUrl;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

