/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.decorator;

import java.util.Map;
import nyla.solutions.core.data.Textable;
import nyla.solutions.core.exception.FormatException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.decorator.TextDecorator;
import nyla.solutions.core.util.Text;

public class TextFormatDecorator
implements TextDecorator<Textable> {
    private Textable target;
    private Map<Object, Object> map;

    @Override
    public String getText() {
        if (this.target == null) {
            return null;
        }
        String template = this.target.getText();
        if (this.map == null) {
            return template;
        }
        try {
            return Text.format(template, this.map);
        }
        catch (FormatException e) {
            throw new SystemException(e);
        }
    }

    @Override
    public void setTarget(Textable target) {
        this.target = target;
    }

    @Override
    public Textable getTarget() {
        return this.target;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
    }
}

