/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.iteration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nyla.solutions.core.patterns.iteration.PageCriteria;
import nyla.solutions.core.patterns.iteration.Paging;

public class PagingCollection<T>
implements Paging<T>,
Serializable,
Collection<T> {
    private final Collection<T> collection;
    private final PageCriteria pageCriteria;
    private static final long serialVersionUID = 7655893737037419650L;
    private boolean last;
    private boolean first;

    public PagingCollection(Collection<T> collection, PageCriteria pageCriteria) {
        if (collection == null) {
            collection = new ArrayList<T>();
        }
        this.collection = collection;
        this.pageCriteria = pageCriteria;
        if (pageCriteria == null || pageCriteria.getBeginIndex() <= 1) {
            this.first = true;
        }
    }

    @Override
    public PageCriteria getPageCriteria() {
        return this.pageCriteria;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public void setLast(boolean last) {
        this.last = last;
    }

    @Override
    public boolean isFirst() {
        return this.first;
    }

    @Override
    public void setFirst(boolean first) {
        this.first = first;
    }

    @Override
    public boolean add(T value) {
        if (value == null) {
            return false;
        }
        if (this.pageCriteria != null && this.size() > this.pageCriteria.getSize()) {
            this.last = false;
            return false;
        }
        return this.collection.add(value);
    }

    @Override
    public boolean addAll(Collection<? extends T> values) {
        boolean wasAllAdded = true;
        Iterator<T> iterator = values.iterator();
        while (iterator.hasNext()) {
            if (this.add(iterator.next())) continue;
            wasAllAdded = false;
        }
        return wasAllAdded;
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.collection.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.collection.containsAll(arg0);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PagingCollection other = (PagingCollection)obj;
        if (this.collection == null ? other.collection != null : !this.collection.equals(other.collection)) {
            return false;
        }
        if (this.first != other.first) {
            return false;
        }
        if (this.last != other.last) {
            return false;
        }
        return !(this.pageCriteria == null ? other.pageCriteria != null : !this.pageCriteria.equals(other.pageCriteria));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
        result = 31 * result + (this.first ? 1231 : 1237);
        result = 31 * result + (this.last ? 1231 : 1237);
        result = 31 * result + (this.pageCriteria == null ? 0 : this.pageCriteria.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        if (this.collection == null) {
            return true;
        }
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.collection == null) {
            return null;
        }
        return this.collection.iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        return this.collection.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.collection.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.collection.retainAll(arg0);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.collection.toArray(arg0);
    }

    public String toString() {
        return "PagingCollection [collection=" + this.collection + ", pageCriteria=" + this.pageCriteria + ", last=" + this.last + ", first=" + this.first + "]";
    }
}

