/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.exception.CommunicationException;
import nyla.solutions.core.patterns.conversion.Converter;

public class ResultSetToMapConverter
implements Converter<ResultSet, Map<String, ?>> {
    @Override
    public Map<String, ?> convert(ResultSet resultSet) {
        ResultSetMetaData meta = null;
        try {
            meta = resultSet.getMetaData();
            int columnCount = meta.getColumnCount();
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (int i = 0; i < columnCount; ++i) {
                String columnName = meta.getColumnName(i + 1);
                if (columnName == null) {
                    columnName = "col" + (i + 1);
                }
                Object value = resultSet.getObject(i + 1);
                rowMap.put(columnName, value);
            }
            return rowMap;
        }
        catch (SQLException e) {
            throw new CommunicationException(e.getMessage(), e);
        }
    }
}

