/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.memento;

import java.io.File;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.patterns.cache.CacheFarm;
import nyla.solutions.core.patterns.memento.Memento;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class FileMemento
implements Memento {
    private final String rootPath;
    private final String fileExtension;

    public FileMemento(String rootPath, String fileExtension) {
        this.rootPath = rootPath;
        this.fileExtension = fileExtension;
    }

    public FileMemento(String rootPath) {
        this(rootPath, Config.getProperty(FileMemento.class, "fileExtension", ".memento"));
    }

    @Override
    public <T> T restore(String savePoint, Class<?> objClass) {
        String location = this.whereIs(savePoint, objClass);
        Object cacheObject = CacheFarm.getCache().get(location);
        if (cacheObject != null) {
            return (T)cacheObject;
        }
        cacheObject = IO.deserialize(new File(location));
        CacheFarm.getCache().put(location, cacheObject);
        return (T)cacheObject;
    }

    @Override
    public void store(String savePoint, Object obj) {
        if (savePoint == null) {
            throw new RequiredException("savePoint");
        }
        if (obj == null) {
            throw new RequiredException("obj");
        }
        String location = this.whereIs(savePoint, obj.getClass());
        Debugger.println(this, "Storing in " + location);
        IO.serializeToFile(obj, new File(location));
    }

    public String getRootPath() {
        return this.rootPath;
    }

    private String whereIs(String savePoint, Class<?> objClass) {
        if (savePoint == null || savePoint.length() == 0) {
            throw new RequiredException("savePoint");
        }
        StringBuffer text = new StringBuffer();
        text.append(this.rootPath).append("/").append(objClass.getName()).append(".").append(savePoint).append(this.fileExtension);
        return text.toString();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }
}

