/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import nyla.solutions.core.exception.RequiredException;

public class PROXY {
    public static Object executeMethod(Object aObject, String aMethodName, Object[] aArguments) throws Exception {
        if (aObject == null) {
            throw new RequiredException("Input object");
        }
        Class[] parameterTypes = null;
        ArrayList parameterTypeArrayList = null;
        if (aArguments != null) {
            parameterTypeArrayList = new ArrayList(aArguments.length);
            for (int i = 0; i < aArguments.length; ++i) {
                if (aArguments[i] == null) continue;
                parameterTypeArrayList.add(aArguments[i].getClass());
            }
            parameterTypes = parameterTypeArrayList.toArray(new Class[parameterTypeArrayList.size()]);
        }
        Method method = aObject.getClass().getDeclaredMethod(aMethodName, parameterTypes);
        return method.invoke(aObject, aArguments);
    }

    public static Method findMethod(Class<?> objClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return objClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (Object.class.equals(objClass)) {
                throw e;
            }
            try {
                return PROXY.findMethod(objClass.getSuperclass(), methodName, parameterTypes);
            }
            catch (NoSuchMethodException parentException) {
                throw e;
            }
        }
    }

    public static Method findMethodByArguments(Class<?> targetClass, String methodName, Object[] arguments) throws NoSuchMethodException {
        if (arguments == null || arguments.length == 0) {
            return targetClass.getDeclaredMethod(methodName, new Class[]{null});
        }
        Class<?>[] parameterTypes = PROXY.toParameterTypes(arguments);
        return targetClass.getDeclaredMethod(methodName, parameterTypes);
    }

    public static Class<?>[] toParameterTypes(Object argument) {
        if (!(argument instanceof Object[])) {
            Class[] classArgs = new Class[]{argument.getClass()};
            return classArgs;
        }
        Object[] arguments = (Object[])argument;
        int len = arguments.length;
        Class[] parameterTypes = new Class[len];
        for (int i = 0; i < len; ++i) {
            parameterTypes[i] = arguments[i].getClass();
        }
        return parameterTypes;
    }
}

