/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Data;
import nyla.solutions.core.data.Identifier;
import nyla.solutions.core.data.PrimaryKey;

public class Criteria
extends Data
implements Comparable<Object>,
PrimaryKey,
Cloneable,
Copier,
Serializable,
Identifier {
    private int primaryKey = -1;
    private String id;
    static final long serialVersionUID = Criteria.class.getName().hashCode();

    protected Criteria() {
        this.primaryKey = -1;
    }

    public Criteria(int aPK) throws IllegalArgumentException {
        if (aPK < 0) {
            this.primaryKey = -1;
        } else {
            this.primaryKey = aPK;
            this.id = String.valueOf(this.primaryKey);
        }
    }

    public Criteria(Criteria criteria) throws IllegalArgumentException {
        this.primaryKey = -1;
        if (criteria == null) {
            return;
        }
        this.id = criteria.id;
        this.primaryKey = criteria.primaryKey;
    }

    public Criteria(String aPK) throws IllegalArgumentException {
        this.id = aPK;
    }

    @Override
    public int getPrimaryKey() {
        return this.primaryKey;
    }

    public Criteria clone() throws CloneNotSupportedException {
        return (Criteria)super.clone();
    }

    public void setPrimaryKey(int primaryKey) throws IllegalArgumentException {
        if (primaryKey > -1) {
            this.primaryKey = primaryKey;
            return;
        }
        this.primaryKey = -1;
    }

    public void setPrimaryKeyInteger(Integer aInteger) {
        if (aInteger == null) {
            throw new IllegalArgumentException("aInteger required in Criteria.setPrimaryKey");
        }
        this.setPrimaryKey(aInteger);
    }

    protected void setPrimaryKeyObject(PrimaryKey aCriteria) throws IllegalArgumentException {
        if (aCriteria == null) {
            return;
        }
        this.setPrimaryKey(aCriteria.getPrimaryKey());
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof Criteria)) {
            return -1;
        }
        Criteria vo = (Criteria)object;
        return Integer.compare(this.getPrimaryKey(), vo.getPrimaryKey());
    }

    protected void setPrimaryKeyString(String primaryKey) throws IllegalArgumentException {
        this.setPrimaryKey(Integer.parseInt(primaryKey));
    }

    public void resetNew() {
        this.primaryKey = -1;
    }

    @Override
    public void copy(Copier aOther) {
        Criteria other = (Criteria)aOther;
        if (other == null) {
            return;
        }
        if (this == other) {
            return;
        }
        if (other.primaryKey > 0) {
            this.primaryKey = other.primaryKey;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Criteria) {
            Criteria otherKey = (Criteria)o;
            return this.primaryKey == otherKey.primaryKey;
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.primaryKey).hashCode();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Object getKey() {
        return this.getId();
    }

    public void setId(String id) {
        this.id = id;
    }
}

