/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.data.Arrayable;
import nyla.solutions.core.data.Mapped;

public class DataRow
implements Arrayable<Object>,
Serializable,
Mapped<String, Serializable> {
    private static final int START_WITH_ZERO = 1;
    private final ArrayList<Object> positionEntries;
    private Map<String, Serializable> nameEntries;
    private int rowNum;
    private static final long serialVersionUID = -6651575339358295855L;

    public DataRow() {
        this.positionEntries = new ArrayList();
    }

    public DataRow(Object[] inputs) {
        this.positionEntries = new ArrayList<Object>(Arrays.asList(inputs));
    }

    public DataRow(Map<String, Serializable> inputs) {
        this();
        this.nameEntries = inputs;
    }

    public DataRow(int rowNum) {
        this();
        this.rowNum = rowNum;
    }

    public DataRow(int rowNum, int size) {
        this.rowNum = rowNum;
        this.positionEntries = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.positionEntries.add(null);
        }
    }

    protected void add(Object aEntry) {
        this.positionEntries.add(aEntry);
    }

    public String retrieveString(int aPosition) {
        try {
            Object o = this.positionEntries.get(aPosition - 1);
            if (o == null) {
                return null;
            }
            return String.valueOf(o);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (aPosition < 1) {
                throw new ArrayIndexOutOfBoundsException("Invalid Position " + aPosition + " less than 1 ");
            }
            throw e;
        }
    }

    public <T> T retrieveObject(int aPosition) {
        return (T)this.positionEntries.get(aPosition - 1);
    }

    public void assignObject(int aPosition, Object obj) {
        if (this.positionEntries.size() < aPosition) {
            for (int i = this.positionEntries.size(); i < aPosition; ++i) {
                this.positionEntries.add(null);
            }
        }
        this.positionEntries.set(aPosition - 1, obj);
    }

    public void assignObject(String key, Serializable value) {
        if (this.nameEntries == null) {
            this.nameEntries = new HashMap<String, Serializable>();
        }
        this.nameEntries.put(key, value);
    }

    public Double retrieveDouble(int aPosition) {
        Object o = this.positionEntries.get(aPosition - 1);
        if (o == null) {
            return null;
        }
        String text = String.valueOf(o);
        if (text == null || text.length() == 0) {
            return null;
        }
        return Double.valueOf(text);
    }

    public Integer retrieveInteger(int aPosition) {
        Object o = this.positionEntries.get(aPosition - 1);
        if (o == null) {
            return -1;
        }
        String text = String.valueOf(o);
        if (text == null || text.length() == 0) {
            return -1;
        }
        return Integer.valueOf(text);
    }

    public Date retrieveDate(int aPosition) {
        Object o = this.positionEntries.get(aPosition - 1);
        if (o == null) {
            return null;
        }
        return (Date)o;
    }

    public String[] getStrings() {
        try {
            if (this.positionEntries == null || this.positionEntries.isEmpty()) {
                return null;
            }
            String[] strings = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                strings[i] = this.retrieveString(i + 1);
            }
            return strings;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("entries=" + this.positionEntries + " ", e);
        }
    }

    public String toString() {
        return "DataRow [" + " positionEntries=" + String.valueOf(this.positionEntries) + ", nameEntries=" + this.nameEntries + ", rowNum=" + this.rowNum + "]";
    }

    public int size() {
        if (this.positionEntries == null) {
            return 0;
        }
        return this.positionEntries.size();
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    @Override
    public Object[] toArray() {
        return this.positionEntries.toArray();
    }

    public String retrieveString(String key) {
        if (this.nameEntries == null) {
            return null;
        }
        return (String)((Object)this.nameEntries.get(key));
    }

    public Date retrieveDate(String key) {
        if (this.nameEntries == null) {
            return null;
        }
        return (Date)this.nameEntries.get(key);
    }

    public Double retrieveDouble(String key) {
        if (this.nameEntries == null) {
            return null;
        }
        return (Double)this.nameEntries.get(key);
    }

    public Integer retrieveInteger(String key) {
        if (this.nameEntries == null) {
            return null;
        }
        return (Integer)this.nameEntries.get(key);
    }

    public <T> T retrieveObject(String key) {
        if (this.nameEntries == null) {
            return null;
        }
        return (T)this.nameEntries.get(key);
    }

    @Override
    public Map<String, Serializable> getMap() {
        return this.nameEntries;
    }

    @Override
    public void setMap(Map<String, Serializable> map) {
        this.nameEntries = map;
    }
}

