/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nyla.solutions.core.data.Mappable;
import nyla.solutions.core.data.Nameable;
import nyla.solutions.core.data.Named;
import nyla.solutions.core.data.Numbered;
import nyla.solutions.core.util.Text;

public class NumberNamed
extends Named
implements Comparable<Object>,
Mappable<Object, Object>,
Serializable,
Nameable,
Numbered {
    private int number;
    static final long serialVersionUID = NumberNamed.class.getName().hashCode();

    public NumberNamed() {
    }

    public NumberNamed(String aName, int aNumber) {
        super(aName);
        this.number = -1;
        this.setNumber(aNumber);
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int aNumber) {
        if (this.number == aNumber) {
            return;
        }
        this.number = aNumber;
    }

    public static Collection<NumberNamed> sortByNumber(Collection<NumberNamed> aNamedVOs) {
        ArrayList<NumberNamed> list = aNamedVOs instanceof List ? (ArrayList<NumberNamed>)aNamedVOs : new ArrayList<NumberNamed>(aNamedVOs);
        Collections.sort(list, new NumberComparator());
        return list;
    }

    @Override
    public int compareTo(Object object) {
        if (object == null || !(object instanceof NumberNamed)) {
            return -1;
        }
        if (super.equals(object)) {
            return 0;
        }
        NumberNamed vo = (NumberNamed)object;
        return Integer.compare(this.getNumber(), vo.getNumber());
    }

    @Override
    public Object getKey() {
        return this.number;
    }

    public void setKey(Object aKey) {
        if (aKey == null) {
            throw new IllegalArgumentException("aKey required in NumberedProperty.setKey");
        }
        if (!Text.isInteger(aKey.toString())) {
            throw new IllegalArgumentException("Integer aKey required in NumberedProperty.setKey key=" + aKey);
        }
        this.setNumber(Integer.parseInt(aKey.toString()));
    }

    @Override
    public Object getValue() {
        return super.getText();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.number;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberNamed other = (NumberNamed)obj;
        return this.number == other.number;
    }

    public static class NumberComparator
    implements Comparator<Object>,
    Serializable {
        static final long serialVersionUID = NumberComparator.class.getName().hashCode();

        @Override
        public int compare(Object first, Object second) {
            if (first == null) {
                return 1;
            }
            NumberNamed vo1 = (NumberNamed)first;
            NumberNamed vo2 = (NumberNamed)second;
            return Integer.compare(vo1.number, vo2.number);
        }
    }
}

