/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.ds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.naming.NamingException;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import nyla.solutions.core.util.Debugger;

public class JndiSocketFactory
extends SSLSocketFactory {
    private static SSLSocketFactory factory = null;
    private static JndiSocketFactory default_factory = null;
    private static KeyStore clientKeystore;
    private static ClassLoader myClassLoader;

    public static void setClassLoader(ClassLoader newLoader) {
        myClassLoader = newLoader;
    }

    private static ClassLoader getClassLoader() {
        if (myClassLoader == null) {
            myClassLoader = ClassLoader.getSystemClassLoader();
        }
        return myClassLoader;
    }

    public static void setDebugOn() {
        System.setProperty("javax.net.debug", "ssl handshake verbose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init(String caKeystoreFile, String clientKeystoreFile, char[] caPassphrase, char[] clientPassphrase, String caKeystoreType, String clientKeystoreType) throws NamingException, Exception {
        int i;
        Class<?> c;
        String protocol;
        if (default_factory != null) {
            return;
        }
        JndiSocketFactory.checkFileSanity(caKeystoreFile, clientKeystoreFile, clientPassphrase);
        if (caKeystoreFile == null) {
            caKeystoreFile = clientKeystoreFile;
        }
        if (!"TLS".equals(protocol = System.getProperty("sslversion", "TLS"))) {
            System.out.println("SECURITY: Using non-standard ssl version: '" + protocol + "'");
        }
        SSLContext sslctx = SSLContext.getInstance(protocol);
        KeyManagerFactory clientKeyManagerFactory = null;
        try {
            c = JndiSocketFactory.getClassLoader().loadClass("com.ca.commons.security.openssl.ParsePkcs12");
            if (c == null) {
                Debugger.printError(JndiSocketFactory.class, "PKI internal error");
                return;
            }
        }
        catch (Exception e) {
            Debugger.printError(JndiSocketFactory.class, "unable to load pkcs12 parser (not in class path?)");
            return;
        }
        Constructor<?> constructor = c.getConstructor(String.class, byte[].class);
        int size = clientPassphrase.length;
        byte[] password = new byte[size];
        for (i = 0; i < size; ++i) {
            password[i] = (byte)clientPassphrase[i];
        }
        Object pkcs12Parser = constructor.newInstance(clientKeystoreFile, password);
        Method getSunKeyStore = c.getMethod("getSunKeyStore", String.class);
        clientKeystore = (KeyStore)getSunKeyStore.invoke(pkcs12Parser, "MyFriend");
        for (i = 0; i < size; ++i) {
            password[i] = 0;
        }
        if (clientKeystoreType == null) {
            clientKeystoreType = "JKS";
        }
        clientKeystore = KeyStore.getInstance(clientKeystoreType);
        if (clientKeystoreFile != null) {
            try (FileInputStream stream = null;){
                stream = new FileInputStream(clientKeystoreFile);
                clientKeystore.load(stream, clientPassphrase);
            }
        }
        clientKeyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        clientKeyManagerFactory.init(clientKeystore, clientPassphrase);
        KeyManager[] keyManagers = null;
        if (clientKeyManagerFactory != null) {
            keyManagers = clientKeyManagerFactory.getKeyManagers();
        }
        if (caKeystoreType == null) {
            caKeystoreType = "JKS";
        }
        KeyStore caKeystore = KeyStore.getInstance(caKeystoreType);
        if (caKeystoreFile != null) {
            try (FileInputStream is = null;){
                is = new FileInputStream(caKeystoreFile);
                caKeystore.load(is, caPassphrase);
            }
        }
        TrustManagerFactory caTrustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        caTrustManagerFactory.init(caKeystore);
        TrustManager[] trustManagers = caTrustManagerFactory.getTrustManagers();
        sslctx.init(keyManagers, trustManagers, null);
        Class<JndiSocketFactory> clazz = JndiSocketFactory.class;
        synchronized (JndiSocketFactory.class) {
            factory = sslctx.getSocketFactory();
            default_factory = new JndiSocketFactory();
            // ** MonitorExit[var20_23] (shouldn't be in output)
            return;
        }
    }

    private static void checkFileSanity(String caKeystoreFile, String clientKeystoreFile, char[] clientPassphrase) throws NamingException {
        if (clientKeystoreFile == null && caKeystoreFile == null) {
            throw new NamingException("SSL Initialisation error: No valid keystore files available.");
        }
        if (caKeystoreFile != null && !new File(caKeystoreFile).exists()) {
            throw new NamingException("SSL Initialisation error: file '" + caKeystoreFile + "' does not exist.");
        }
        if (clientKeystoreFile != null && clientPassphrase != null && !new File(clientKeystoreFile).exists()) {
            throw new NamingException("SSL Initialisation error: file '" + clientKeystoreFile + "' does not exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketFactory getDefault() {
        Class<JndiSocketFactory> clazz = JndiSocketFactory.class;
        synchronized (JndiSocketFactory.class) {
            if (default_factory == null) {
                default_factory = new JndiSocketFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return default_factory;
        }
    }

    public static KeyStore getClientKeyStore() {
        return clientKeystore;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port, client_host, client_port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port, client_host, client_port);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException, UnknownHostException {
        return factory.createSocket(socket, host, port, autoclose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return factory.getSupportedCipherSuites();
    }

    static {
        myClassLoader = null;
    }
}

