/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.net.rmi;

import java.net.URI;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import nyla.solutions.core.data.Identifier;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.ConnectionException;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;

public class RMI {
    private final String host;
    private final int port;
    private final Registry registry;

    public RMI(String host, int port) throws RemoteException {
        this(host, port, RMI.getRegistry(host, port));
    }

    RMI(String host, int port, Registry registry) {
        this.host = host;
        this.port = port;
        this.registry = registry;
    }

    public <T> T lookup(String name) {
        try {
            return (T)this.registry.lookup(name);
        }
        catch (Exception e) {
            String[] list = null;
            try {
                list = this.registry.list();
            }
            catch (Exception exp) {
                Debugger.printWarn(this, exp.getMessage());
            }
            throw new ConnectionException("Cannot find:" + name + " in list " + Debugger.toString(list) + " rmi//:" + this.host + ":" + this.port + "/" + name + " ERROR:" + e.getMessage(), e);
        }
    }

    public static <T> T lookup(URI rmiUrl) {
        try {
            return (T)Naming.lookup(rmiUrl.toString());
        }
        catch (Exception e) {
            throw new ConnectionException(rmiUrl + " ERROR:" + Debugger.stackTrace(e));
        }
    }

    public void rebind(String name, Remote remote) {
        try {
            Remote stub = UnicastRemoteObject.exportObject(remote, 0);
            this.registry.rebind(name, stub);
            Debugger.println(RMI.class, "Binded object:" + remote + " host:" + this.host + " port:" + this.port);
        }
        catch (Exception e) {
            throw new ConfigException(Debugger.stackTrace(e));
        }
    }

    public String[] list() {
        try {
            return this.registry.list();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void rebind(Remote[] remotes) {
        String rmiUrl = null;
        for (int i = 0; i < remotes.length; ++i) {
            rmiUrl = remotes[i] instanceof Identifier && !Text.isNull(((Identifier)((Object)remotes[i])).getId()) ? ((Identifier)((Object)remotes[i])).getId() : Config.getProperty(remotes[i].getClass(), "bind.rmi.url");
            this.rebind(rmiUrl, remotes[i]);
        }
    }

    public static Registry getRegistry() throws RemoteException {
        return LocateRegistry.getRegistry(Config.getProperty(RMI.class, "host"), Config.getPropertyInteger(RMI.class, "port"));
    }

    public static Registry getRegistry(String host, int port) throws RemoteException {
        return LocateRegistry.getRegistry(host, port);
    }

    public static void startRmiRegistry(int port) throws RemoteException {
        LocateRegistry.createRegistry(port);
    }

    public static void main(String[] args) {
        try {
            RMI.startRmiRegistry(Integer.parseInt(args[0]));
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

