/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.generator;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.creational.Creator;
import nyla.solutions.core.patterns.creational.generator.CreatorFactoryByPropertyName;
import nyla.solutions.core.util.Digits;
import nyla.solutions.core.util.JavaBean;
import nyla.solutions.core.util.Text;

public class JavaBeanGeneratorCreator<T>
implements Creator<T> {
    private Set<Class<?>> generateNestedClassSet = null;
    private boolean mustGenerateNestedAll = false;
    private Digits digits = new Digits();
    private Set<String> randomizeProperties = new HashSet<String>();
    private final Class<T> creationClass;
    private final T prototype;
    private Set<String> fixSet = null;
    private boolean mustRandomizeAll = false;
    private boolean throwExceptionForMissingProperty = false;
    private final Map<String, Creator<?>> creatorForClassMap;
    private DateTimeFormatter textDateFormat = DateTimeFormatter.ISO_DATE;
    private final CreatorFactoryByPropertyName creatorFactoryByPropertyName;

    private JavaBeanGeneratorCreator(Class<T> creationClass, Set<Class<?>> generateNestedClassSet, boolean mustGenerateNestedAll, Digits digits, Set<String> fixSet, boolean mustRandomizeAll, Map<String, Creator<?>> creatorForClassMap) {
        this(creationClass, null);
        this.generateNestedClassSet = generateNestedClassSet;
        this.mustGenerateNestedAll = mustGenerateNestedAll;
        this.digits = digits;
        this.fixSet = fixSet;
        this.mustRandomizeAll = mustRandomizeAll;
        if (mustRandomizeAll) {
            this.randomizeAll();
        }
        this.creatorForClassMap.putAll(creatorForClassMap);
    }

    public JavaBeanGeneratorCreator(T prototype) {
        this(prototype.getClass(), prototype);
    }

    public JavaBeanGeneratorCreator(Class<T> clz) {
        this(clz, null);
    }

    public JavaBeanGeneratorCreator(Class<T> clz, T prototype) {
        this.creationClass = clz;
        this.prototype = prototype;
        this.creatorForClassMap = new HashMap();
        this.creatorFactoryByPropertyName = new CreatorFactoryByPropertyName(this.textDateFormat);
        this.creatorForClassMap.put(String.class.getName(), () -> Text.generateId());
        this.creatorForClassMap.put(Integer.class.getName(), () -> this.digits.generateInteger());
        this.creatorForClassMap.put(Integer.TYPE.getName(), () -> this.digits.generateInteger());
        this.creatorForClassMap.put(Long.class.getName(), () -> this.digits.generateLong());
        this.creatorForClassMap.put(Long.TYPE.getName(), () -> this.digits.generateLong());
        this.creatorForClassMap.put(Short.TYPE.getName(), () -> this.digits.generateShort());
        this.creatorForClassMap.put(Short.class.getName(), () -> this.digits.generateShort());
        this.creatorForClassMap.put(Double.class.getName(), () -> this.digits.generateDouble());
        this.creatorForClassMap.put(Double.TYPE.getName(), () -> this.digits.generateDouble());
        this.creatorForClassMap.put(Character.TYPE.getName(), () -> Character.valueOf(Text.generateId().charAt(0)));
        this.creatorForClassMap.put(Character.class.getName(), () -> Character.valueOf(Text.generateId().charAt(0)));
        this.creatorForClassMap.put(Float.TYPE.getName(), () -> Float.valueOf(this.digits.generateFloat()));
        this.creatorForClassMap.put(Float.class.getName(), () -> Float.valueOf(this.digits.generateFloat()));
        this.creatorForClassMap.put(Byte.TYPE.getName(), () -> Text.generateId().getBytes(IO.CHARSET)[0]);
        this.creatorForClassMap.put(Byte.class.getName(), () -> Text.generateId().getBytes(IO.CHARSET)[0]);
        Creator<Boolean> booleanCreator = () -> {
            if (Calendar.getInstance().getTime().getTime() % 2L == 0L) {
                return true;
            }
            return false;
        };
        this.creatorForClassMap.put(Boolean.class.getName(), booleanCreator);
        this.creatorForClassMap.put(Boolean.TYPE.getName(), booleanCreator);
        this.creatorForClassMap.put(BigDecimal.class.getName(), () -> this.digits.generateBigDecimal());
        this.creatorForClassMap.put(Time.class.getName(), () -> new Time(Calendar.getInstance().getTime().getTime()));
        this.creatorForClassMap.put(Date.class.getName(), () -> new Date(Calendar.getInstance().getTime().getTime()));
        this.creatorForClassMap.put(java.util.Date.class.getName(), () -> Calendar.getInstance().getTime());
        this.creatorForClassMap.put(Timestamp.class.getName(), () -> new Timestamp(Calendar.getInstance().getTime().getTime()));
        this.creatorForClassMap.put(Calendar.class.getName(), () -> Calendar.getInstance());
        this.creatorForClassMap.put(LocalTime.class.getName(), () -> LocalTime.now());
        this.creatorForClassMap.put(LocalDate.class.getName(), () -> LocalDate.now());
        this.creatorForClassMap.put(LocalDateTime.class.getName(), () -> LocalDateTime.now());
        this.creatorForClassMap.put(BigInteger.class.getName(), () -> BigInteger.ONE);
        this.creatorForClassMap.put(BigDecimal.class.getName(), () -> BigDecimal.ONE);
    }

    public static <T> JavaBeanGeneratorCreator<T> of(Class<T> objClass) {
        return new JavaBeanGeneratorCreator<T>(objClass).randomizeAll().generateNestedAll();
    }

    public JavaBeanGeneratorCreator setTextDateFormat(DateTimeFormatter textDateFormat) {
        this.textDateFormat = textDateFormat;
        return this;
    }

    @Override
    public T create() {
        try {
            Object obj = ClassPath.newInstance(this.creationClass);
            if (this.prototype != null) {
                JavaBean.populate(JavaBean.toMap(this.prototype), obj);
            }
            for (String property : this.randomizeProperties) {
                try {
                    PropertyDescriptor pd = JavaBean.getPropertyDescriptor(obj, property);
                    Class<Class> clz = pd.getPropertyType();
                    Creator<?> creator = this.determineCreator(clz, pd);
                    if (creator != null) {
                        Object value;
                        try {
                            value = creator.create();
                        }
                        catch (RuntimeException e) {
                            throw new IllegalArgumentException("Cannot create class:" + clz.getName() + " property:" + property + " for object:" + obj, e);
                        }
                        JavaBean.setProperty(obj, property, value, this.throwExceptionForMissingProperty);
                        continue;
                    }
                    if (clz.isAssignableFrom(Class.class)) continue;
                    if (clz.isEnum()) {
                        Object myenum = Enum.valueOf(clz, clz.getEnumConstants()[0].toString());
                        JavaBean.setProperty(obj, property, myenum, this.throwExceptionForMissingProperty);
                        continue;
                    }
                    if (!clz.getName().startsWith("java.") && (this.mustGenerateNestedAll || this.generateNestedClassSet != null && this.generateNestedClassSet.contains(clz))) {
                        JavaBeanGeneratorCreator<?> javaBeanGeneratorCreator = this.cloneForClass(clz);
                        JavaBean.setProperty(obj, property, javaBeanGeneratorCreator.create(), this.throwExceptionForMissingProperty);
                        continue;
                    }
                    JavaBean.setProperty(obj, property, ClassPath.newInstance(clz), this.throwExceptionForMissingProperty);
                }
                catch (Exception e) {
                    throw new SetupException("Cannot create property:" + property + " for object class:" + this.creationClass.getName() + "  ERROR:" + e.getMessage(), e);
                }
            }
            return obj;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Creator<?> determineCreator(Class<?> clz, PropertyDescriptor pd) {
        String propertyName = pd.getName().toLowerCase();
        String cacheMapKey = clz.getName() + "." + propertyName;
        Creator<Object> creator = this.creatorForClassMap.get(cacheMapKey);
        if (creator != null) {
            return creator;
        }
        if (String.class.equals(clz) && propertyName != null) {
            String lowerProperty = propertyName.toLowerCase();
            creator = this.creatorFactoryByPropertyName.forProperty(lowerProperty);
            this.creatorForClassMap.put(cacheMapKey, creator);
            return creator;
        }
        return this.creatorForClassMap.get(clz.getName());
    }

    public JavaBeanGeneratorCreator<T> randomizeProperty(String property) {
        if (property == null || property.length() == 0) {
            return this;
        }
        this.randomizeProperties.add(property);
        return this;
    }

    public JavaBeanGeneratorCreator<T> randomizeAll() {
        this.mustRandomizeAll = true;
        this.randomizeProperties = JavaBean.getPropertyNames(this.creationClass);
        return this;
    }

    public JavaBeanGeneratorCreator<T> fixedProperties(String ... fixedPropertyNames) {
        if (fixedPropertyNames == null || fixedPropertyNames.length == 0) {
            return this;
        }
        this.fixSet = new HashSet<String>(Arrays.asList(fixedPropertyNames));
        Map<Object, Object> map = null;
        map = this.prototype != null ? JavaBean.toMap(this.prototype) : JavaBean.toMap(ClassPath.newInstance(this.creationClass));
        if (map == null || map.isEmpty()) {
            return this;
        }
        String propertyName = null;
        for (Object propertyNameObject : map.keySet()) {
            propertyName = String.valueOf(propertyNameObject);
            if (this.fixSet.contains(propertyName)) continue;
            this.randomizeProperty(propertyName);
        }
        return this;
    }

    public JavaBeanGeneratorCreator<T> generateNestedClass(Class<?> aClass) {
        if (this.generateNestedClassSet == null) {
            this.generateNestedClassSet = new HashSet();
        }
        this.generateNestedClassSet.add(aClass);
        return this;
    }

    public JavaBeanGeneratorCreator<T> generateNestedAll() {
        this.mustGenerateNestedAll = true;
        return this;
    }

    public <NewType> JavaBeanGeneratorCreator<NewType> cloneForClass(Class<NewType> newClass) {
        return new JavaBeanGeneratorCreator<NewType>(newClass, this.generateNestedClassSet, this.mustGenerateNestedAll, this.digits, this.fixSet, this.mustRandomizeAll, this.creatorForClassMap);
    }

    public <ObjectType> JavaBeanGeneratorCreator<T> creatorForClass(Class<ObjectType> aClass, Creator<ObjectType> creator) {
        this.creatorForClassMap.put(aClass.getName(), creator);
        return this;
    }

    protected Map<String, Creator<?>> getCreatorForClassMap() {
        return this.creatorForClassMap;
    }

    protected Set<String> getRandomizeProperties() {
        return this.randomizeProperties;
    }
}

