/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.memento;

import nyla.solutions.core.data.MethodCallFact;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SummaryException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.creational.proxy.ObjectProxy;
import nyla.solutions.core.patterns.memento.Memento;
import nyla.solutions.core.patterns.memento.MethodCallObjectPreparer;
import nyla.solutions.core.util.Debugger;

public class MethodCallSavePointPlayer<T> {
    private MethodCallObjectPreparer methodCallObjectPreparer = null;
    private final T target;

    public MethodCallSavePointPlayer(T target) {
        if (target == null) {
            throw new RequiredException("target");
        }
        this.target = target;
    }

    public synchronized void playMethodCalls(Memento memento, String ... savePoints) {
        String savePoint = null;
        MethodCallFact methodCallFact = null;
        SummaryException exceptions = new SummaryException();
        for (int i = 0; i < savePoints.length; ++i) {
            savePoint = savePoints[i];
            if (savePoint == null || savePoint.length() == 0 || savePoint.trim().length() == 0) continue;
            Debugger.println(this, "processing savepoint=" + savePoint);
            methodCallFact = (MethodCallFact)memento.restore(savePoint, MethodCallFact.class);
            try {
                ObjectProxy.executeMethod(this.prepareObject(methodCallFact, savePoint), methodCallFact);
                continue;
            }
            catch (Exception e) {
                exceptions.addException(new SystemException("savePoint=" + savePoint + " methodCallFact=" + methodCallFact + " exception=" + Debugger.stackTrace(e)));
                throw new SystemException(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw exceptions;
        }
    }

    private Object prepareObject(MethodCallFact fact, String savePoint) {
        if (this.methodCallObjectPreparer != null) {
            return this.methodCallObjectPreparer.prepare(this.target, fact, savePoint);
        }
        return this.target;
    }

    public T getTarget() {
        return this.target;
    }

    public MethodCallObjectPreparer getMethodCallObjectPreparer() {
        return this.methodCallObjectPreparer;
    }

    public void setMethodCallObjectPreparer(MethodCallObjectPreparer methodCallObjectPreparer) {
        this.methodCallObjectPreparer = methodCallObjectPreparer;
    }

    public void record(String savePoint, MethodCallFact methodCallFact) {
    }
}

