/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.observer;

import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.patterns.observer.Subject;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.patterns.observer.Topic;
import nyla.solutions.core.util.Debugger;

public class SubjectRegistry {
    private Map<String, Subject<?>> registry = new HashMap();

    public void notify(String subjectName, Object data) {
        Subject<?> object = this.registry.get(subjectName);
        if (object == null) {
            return;
        }
        try {
            Subject<?> subject = object;
            subject.notify(data);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(object.getClass().getName() + " " + Debugger.stackTrace(e));
        }
    }

    public <T> void register(String subjectName, SubjectObserver<T> subjectObserver) {
        Subject<?> subject = this.registry.get(subjectName);
        if (subject == null) {
            subject = new Topic(subjectName);
        }
        this.register(subjectName, subjectObserver, subject);
    }

    public <T> void register(String subjectName, SubjectObserver<T> subjectObserver, Subject<T> subject) {
        subject.add(subjectObserver);
        this.registry.put(subjectName, subject);
    }

    public <T> void removeRegistration(String subjectName, SubjectObserver<T> subjectObserver) {
        Subject<?> subject = this.registry.get(subjectName);
        if (subject == null) {
            return;
        }
        subject.remove(subjectObserver);
    }

    public Map<String, Subject<?>> getRegistry() {
        return this.registry;
    }

    public void setSubjectObservers(Map<Object, SubjectObserver> registry) {
        for (Map.Entry<Object, SubjectObserver> entry : registry.entrySet()) {
            this.register(entry.getKey().toString(), entry.getValue());
        }
    }
}

