/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.io.Serializable;
import java.util.Date;

public class GenericField
implements Serializable {
    private static final long serialVersionUID = -463965000413175143L;
    private Object value = null;
    private String fieldName = null;
    private Class<?> objClass = null;

    public GenericField(String className, String fieldName, String textValue) {
        if (className == null) {
            throw new IllegalArgumentException("className required");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName required");
        }
        className = className.trim();
        this.fieldName = fieldName.trim();
        if (className.equals("String") || String.class.getName().equals(className)) {
            this.objClass = String.class;
        } else if (className.equalsIgnoreCase("Double") || Double.class.getName().equals(className)) {
            this.objClass = Double.class;
        } else if (className.equals("int") || className.equals("Integer") || Integer.class.getName().equals(className)) {
            this.objClass = Integer.class;
        } else if (className.equalsIgnoreCase("Long") || Long.class.getName().equals(className)) {
            this.objClass = Long.class;
        } else if (className.equalsIgnoreCase("Float") || Float.class.getName().equals(className)) {
            this.objClass = Float.class;
        } else if (className.equalsIgnoreCase("byte") || Byte.class.getName().equals(className)) {
            this.objClass = Byte.class;
        } else if (className.equalsIgnoreCase("Short") || Short.class.getName().equals(className)) {
            this.objClass = Short.class;
        } else if ("Date".equalsIgnoreCase(className) || Date.class.getName().equals(className)) {
            this.objClass = Date.class;
        } else if (className.equalsIgnoreCase("char") || className.equalsIgnoreCase("Character") || Character.class.getName().equals(className)) {
            this.objClass = Character.class;
        } else {
            throw new IllegalArgumentException("className:" + className + " unsupported");
        }
    }

    public boolean isDate() {
        return GenericField.isDate(this);
    }

    public static boolean isDate(GenericField field) {
        if (field == null) {
            return false;
        }
        String fieldName = field.getFieldName();
        if ("serialVersionUID".equals(fieldName)) {
            return false;
        }
        Class<?> typeClass = field.getObjClass();
        if (typeClass == null) {
            return false;
        }
        String className = typeClass.getName();
        System.out.println("declaringClass.getName()=" + className);
        return className.matches("java.util.Date");
    }

    public static boolean isSupportedFieldType(String className) {
        if (className.equals("String") || String.class.getName().equals(className)) {
            return true;
        }
        if (className.equalsIgnoreCase("Double") || Double.class.getName().equals(className)) {
            return true;
        }
        if (className.equals("int") || className.equals("Integer") || Integer.class.getName().equals(className)) {
            return true;
        }
        if (className.equalsIgnoreCase("Long") || Long.class.getName().equals(className)) {
            return true;
        }
        if (className.equalsIgnoreCase("Float") || Float.class.getName().equals(className)) {
            return true;
        }
        if (className.equalsIgnoreCase("byte") || Byte.class.getName().equals(className)) {
            return true;
        }
        if (className.equalsIgnoreCase("Short") || Short.class.getName().equals(className)) {
            return true;
        }
        if ("Date".equalsIgnoreCase(className) || Date.class.getName().equals(className)) {
            return true;
        }
        return className.equalsIgnoreCase("char") || className.equalsIgnoreCase("Character") || Character.class.getName().equals(className);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    public void setObjClass(Class<?> objClass) {
        this.objClass = objClass;
    }

    public void setLong(Long value) {
        this.value = value;
    }

    public void setDouble(Double value) {
        this.value = value;
    }

    public void setShort(Short value) {
        this.value = value;
    }

    public void setByte(Byte value) {
        this.value = value;
    }

    public void setFloat(Float value) {
        this.value = value;
    }

    public void setInt(Integer value) {
        this.value = value;
    }

    public void setChar(Character value) {
        this.value = value;
    }

    public void setDate(Date value) {
        this.value = value;
    }
}

