/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.workthread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.Disposable;
import nyla.solutions.core.patterns.workthread.WorkQueue;
import nyla.solutions.core.patterns.workthread.Worker;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class ExecutorBoss
implements Disposable {
    private final ExecutorService executor;
    private final int workerCount;
    private static ExecutorBoss instance = null;
    public static final int DEFAULT_WORK_COUNT = Config.getPropertyInteger(ExecutorBoss.class, "DEFAULT_WORK_COUNT", 10);

    public ExecutorBoss(int workerCount) {
        try {
            this.executor = Executors.newFixedThreadPool(workerCount);
            this.workerCount = workerCount;
        }
        catch (IllegalArgumentException e) {
            throw new RequiredException("workerCount:" + workerCount + " ERROR" + e.getMessage());
        }
    }

    public <T> Collection<T> startWorking(Callable<T>[] callables) {
        ArrayList<Future<T>> list = new ArrayList<Future<T>>();
        for (int i = 0; i < callables.length; ++i) {
            list.add(this.executor.submit(callables[i]));
        }
        ArrayList resultList = new ArrayList(callables.length);
        for (Future future : list) {
            try {
                Object output = future.get();
                if (output == null) continue;
                resultList.add(output);
            }
            catch (InterruptedException e) {
                throw new SystemException(e);
            }
            catch (ExecutionException e) {
                throw new SystemException(e);
            }
        }
        return resultList;
    }

    public <T, I> Collection<T> startWorking(Collection<Callable<I>> callables) {
        ArrayList<Future<I>> list = new ArrayList<Future<I>>();
        for (Callable<I> callable : callables) {
            list.add(this.executor.submit(callable));
        }
        ArrayList resultList = new ArrayList(callables.size());
        for (Future future : list) {
            try {
                Object output = future.get();
                if (output == null) continue;
                resultList.add(output);
            }
            catch (InterruptedException e) {
                throw new SystemException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new SystemException(cause);
            }
        }
        return resultList;
    }

    public Collection<Future<?>> startWorking(WorkQueue queue) {
        return this.startWorking(queue, false);
    }

    public Collection<Future<?>> startWorking(WorkQueue queue, boolean background) {
        ArrayList futures = new ArrayList(queue.size());
        while (queue.hasMoreTasks()) {
            futures.add(this.executor.submit(queue.nextTask()));
        }
        if (background) {
            return futures;
        }
        try {
            for (Future<?> future : futures) {
                future.get();
            }
            return futures;
        }
        catch (InterruptedException e) {
            throw new SystemException(e);
        }
        catch (ExecutionException e) {
            throw new SystemException(e);
        }
    }

    public Future<?> startWorking(Worker worker) {
        return this.executor.submit(worker);
    }

    @Override
    public void dispose() {
        try {
            this.executor.shutdown();
        }
        catch (Exception e) {
            Debugger.printWarn(e);
        }
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public static synchronized ExecutorBoss getBoss() {
        if (instance == null) {
            instance = new ExecutorBoss(DEFAULT_WORK_COUNT);
        }
        return instance;
    }
}

