/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.data;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.Identifiable;
import nyla.solutions.core.security.data.SecurityCredential;

public class LoginCredential
implements SecurityCredential,
Principal,
Serializable,
Identifiable {
    private static final long serialVersionUID = 1871190779208616626L;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String domain = "";
    private String loginID = "";
    private char[] password = null;

    public LoginCredential() {
    }

    public LoginCredential(String loginID, String password) {
        this.setLoginID(loginID);
        this.setPassword(password);
    }

    public LoginCredential(String loginID, String password, String domain) {
        this(loginID, password);
        this.setDomain(domain);
    }

    public LoginCredential(String loginID, char[] password, String domain) {
        this(loginID, password);
        this.setDomain(domain);
    }

    public LoginCredential(String loginID, char[] password) {
        this.setLoginID(loginID);
        this.setPassword(password);
    }

    public final char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        return (char[])this.password.clone();
    }

    public final void setPassword(char[] password) {
        this.password = (char[])(password == null ? null : (char[])password.clone());
    }

    public final void setPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("password required in LoginCredential.setPassword");
        }
        this.password = password.toCharArray();
    }

    @Override
    public String getId() {
        return this.loginID;
    }

    @Override
    public String getName() {
        return this.loginID;
    }

    @Override
    public final String getLoginID() {
        return this.loginID;
    }

    public final void setLoginID(String loginID) {
        if (loginID == null) {
            throw new IllegalArgumentException("loginID required in LoginCredential.setLoginID");
        }
        this.loginID = loginID;
    }

    public final String getDomain() {
        return this.domain;
    }

    public final void setDomain(String domain) {
        if (domain == null) {
            domain = "";
        }
        this.domain = domain;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public void setId(String id) {
        this.setLoginID(id);
    }
}

