/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.stats;

import java.util.Arrays;
import java.util.List;

public class Mathematics {
    public double variance(Number ... a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = this.mean(a);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (a[i].doubleValue() - avg) * (a[i].doubleValue() - avg);
        }
        return sum / (double)(a.length - 1);
    }

    public double mean(Number ... a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double sum = this.sum(a);
        return sum / (double)a.length;
    }

    public double varp(Number ... a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = this.mean(a);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (a[i].doubleValue() - avg) * (a[i].doubleValue() - avg);
        }
        return sum / (double)a.length;
    }

    public double stdDev(Number ... a) {
        if (a == null || a.length == 0) {
            return -1.0;
        }
        return Math.sqrt(this.varp(a));
    }

    public double stdDev(List<? extends Number> averages) {
        Number[] numbers = new Number[averages.size()];
        averages.toArray(numbers);
        return this.stdDev(numbers);
    }

    public double sum(Number ... a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i].doubleValue();
        }
        return sum;
    }

    public double percentile(double percentile, Number ... a) {
        long total = a.length;
        int n = Math.round(Double.valueOf((double)total * (percentile / 100.0)).floatValue());
        Object[] sortCopy = Arrays.copyOf(a, a.length);
        Arrays.sort(sortCopy);
        return ((Number)sortCopy[n - 1]).doubleValue();
    }
}

