/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class QueueSupplier<T>
implements Supplier<T>,
Queue<T> {
    private final Queue<T> queue;

    public QueueSupplier(Queue<T> queue) {
        if (queue == null) {
            throw new NullPointerException("Provided queue is null");
        }
        this.queue = queue;
    }

    public QueueSupplier() {
        this(new ConcurrentLinkedQueue());
    }

    @Override
    public boolean add(T t) {
        return this.queue.add(t);
    }

    @Override
    public boolean offer(T t) {
        return this.queue.offer(t);
    }

    @Override
    public T remove() {
        return this.queue.remove();
    }

    @Override
    public T poll() {
        return this.queue.poll();
    }

    @Override
    public T element() {
        return this.queue.element();
    }

    @Override
    public T peek() {
        return this.queue.peek();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.queue.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueSupplier that = (QueueSupplier)o;
        return Objects.equals(this.queue, that.queue);
    }

    @Override
    public int hashCode() {
        return this.queue.hashCode();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.queue.spliterator();
    }

    @Override
    public Stream<T> stream() {
        return this.queue.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.queue.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.queue.forEach(action);
    }

    @Override
    public T get() {
        return this.queue.poll();
    }
}

