/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.ds;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import nyla.solutions.core.util.Config;

public class SSLConfigSocketFactory
extends SocketFactory {
    public static final String LDAP_SSL_KEYSTORE_PROP = "LDAP_SSL_KEYSTORE";
    public static final String LDAP_SSL_TRUSTSTORE_PROP = "LDAP_SSL_TRUSTSTORE";
    public static final String LDAP_SSL_KEYSTORE_PASSWORS_PROP = "LDAP_SSL_KEYSTORE_PASSWORD";
    public static final String LDAP_SSL_TRUSTSTORE_PASSWORS_PROP = "LDAP_SSL_TRUSTSTORE_PASSSWORD";
    private static SocketFactory instance;
    private SSLContext context = SSLContext.getInstance("TLS");
    private SSLSocketFactory sslSocketFactory;

    public SSLConfigSocketFactory() throws Exception {
        String keyStore = Config.getProperty(LDAP_SSL_KEYSTORE_PROP);
        String trustStore = Config.getProperty(LDAP_SSL_TRUSTSTORE_PROP);
        String keyStorePassword = Config.getProperty(LDAP_SSL_KEYSTORE_PASSWORS_PROP);
        String trustStorePassword = Config.getProperty(LDAP_SSL_TRUSTSTORE_PASSWORS_PROP);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("JKS");
        try (FileInputStream inputStream = new FileInputStream(keyStore);){
            ks.load(inputStream, keyStorePassword.toCharArray());
        }
        kmf.init(ks, keyStorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ts = KeyStore.getInstance("JKS");
        try (FileInputStream inputStream = new FileInputStream(trustStore);){
            ts.load(inputStream, trustStorePassword.toCharArray());
        }
        tmf.init(ts);
        this.context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        this.sslSocketFactory = this.context.getSocketFactory();
    }

    public static synchronized SocketFactory getDefault() {
        if (instance == null) {
            try {
                instance = new SSLConfigSocketFactory();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate the SSL Socket Factory.", e);
            }
        }
        return instance;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.sslSocketFactory.createSocket();
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(s, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(s, i, inetAddress, i1);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.sslSocketFactory.createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.sslSocketFactory.createSocket(inetAddress, i, inetAddress1, i1);
    }
}

