/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.exception.fault;

import java.util.Map;
import nyla.solutions.core.exception.FormatException;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.fault.Fault;
import nyla.solutions.core.exception.fault.FormatFaultException;
import nyla.solutions.core.patterns.decorator.TextDecorator;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.JavaBean;
import nyla.solutions.core.util.Text;

public class FaultFormatTextDecorator
implements TextDecorator<Fault> {
    private Fault target;
    private TextDecorator<Object> argumentTextDecorator;
    private String template;
    private String templateName;
    private String argumentKeyName = "argument";

    public FaultFormatTextDecorator() {
    }

    public FaultFormatTextDecorator(Fault target, String templateName) {
        this.target = target;
        this.templateName = templateName;
    }

    @Override
    public String getText() {
        if (this.target == null) {
            return null;
        }
        try {
            if ((this.template == null || this.template.length() == 0) && this.templateName != null) {
                try {
                    this.template = Text.loadTemplate(this.templateName);
                }
                catch (Exception e) {
                    throw new SetupException("Cannot load template:" + this.templateName, e);
                }
            }
            Map<Object, Object> faultMap = JavaBean.toMap(this.target);
            if (this.argumentTextDecorator != null) {
                this.argumentTextDecorator.setTarget(this.target.getArgument());
                faultMap.put(this.argumentKeyName, this.argumentTextDecorator.getText());
            }
            return Text.format(this.template, faultMap);
        }
        catch (FormatException e) {
            throw new FormatFaultException(this.template, e);
        }
    }

    @Override
    public void setTarget(Fault target) {
        this.target = target;
    }

    @Override
    public Fault getTarget() {
        return this.target;
    }

    public TextDecorator<Object> getArgumentTextDecorator() {
        return this.argumentTextDecorator;
    }

    public void setArgumentTextDecorator(TextDecorator<Object> argumentTextDecorator) {
        this.argumentTextDecorator = argumentTextDecorator;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getArgumentKeyName() {
        return this.argumentKeyName;
    }

    public void setArgumentKeyName(String argumentKeyName) {
        this.argumentKeyName = argumentKeyName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = Config.interpret(templateName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argumentKeyName == null ? 0 : this.argumentKeyName.hashCode());
        result = 31 * result + (this.argumentTextDecorator == null ? 0 : this.argumentTextDecorator.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        result = 31 * result + (this.templateName == null ? 0 : this.templateName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FaultFormatTextDecorator other = (FaultFormatTextDecorator)obj;
        if (this.argumentKeyName == null ? other.argumentKeyName != null : !this.argumentKeyName.equals(other.argumentKeyName)) {
            return false;
        }
        if (this.argumentTextDecorator == null ? other.argumentTextDecorator != null : !this.argumentTextDecorator.equals(other.argumentTextDecorator)) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
            return false;
        }
        return !(this.templateName == null ? other.templateName != null : !this.templateName.equals(other.templateName));
    }
}

