/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.converter;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.patterns.conversion.TextToEmailsConverter;

public class FilesToEmailsConverter
implements Converter<File, Set<String>> {
    private final TextToEmailsConverter textToEmailsConverter = new TextToEmailsConverter();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> convert(File file) {
        if (file.isDirectory()) {
            HashSet<String> emails = new HashSet<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(file.toPath());){
                if (stream == null) {
                    Set set = Collections.EMPTY_SET;
                    return set;
                }
                for (Path path : stream) {
                    Set<String> results = this.convert(path.toFile());
                    if (results.isEmpty()) continue;
                    emails.addAll(results);
                }
                HashSet<String> hashSet = emails;
                return hashSet;
            }
            catch (IOException e) {
                throw new SystemException("Unable to convert file:" + file + " error:" + e.getMessage(), e);
            }
        }
        Path path = file.toPath();
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.{json,txt,csv,xml,yml}");
        if (!pathMatcher.matches(path)) {
            return Collections.emptySet();
        }
        try {
            List<String> list = Files.readAllLines(path);
            if (list != null) return list.stream().map(line -> {
                Set<String> set = this.textToEmailsConverter.convert((String)line);
                if (set == null) {
                    set = Collections.emptySet();
                }
                return set;
            }).flatMap(Collection::stream).collect(Collectors.toSet());
            return Collections.emptySet();
        }
        catch (IOException e) {
            throw new SystemException("Unable to convert file:" + file + " error:" + e.getMessage(), e);
        }
    }
}

