/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv;

import java.lang.reflect.Method;
import java.util.TreeMap;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.util.Scheduler;
import nyla.solutions.core.util.Text;

public class BeanPropertiesToCsvHeaderConverter<ObjectType>
implements Converter<ObjectType, String> {
    private static final String GET_PREFIX = "get";
    private static final String SEPARATOR = ",";
    private static final String QUOTE = "\"";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private TreeMap<String, Method> methods;

    @Override
    public String convert(ObjectType sourceObject) {
        Class<?> objectClass = sourceObject.getClass();
        return this.toHeaderRow(objectClass);
    }

    public String toHeaderRow(Class<?> objectClass) {
        if (ClassPath.isPrimitive(objectClass) || Scheduler.isDateOrTime(objectClass)) {
            return objectClass.getSimpleName() + "\n";
        }
        Method[] methodArray = objectClass.getMethods();
        String methodName = null;
        this.methods = new TreeMap();
        for (int i = 0; i < methodArray.length; ++i) {
            Method m = methodArray[i];
            methodName = m.getName();
            if (!methodName.startsWith(GET_PREFIX) || m.getParameterCount() != 0 || methodName.equals("getClass")) continue;
            this.methods.put(methodName, m);
        }
        StringBuilder csv = new StringBuilder();
        for (String keyMethodName : this.methods.keySet()) {
            if (csv.length() != 0) {
                csv.append(SEPARATOR);
            }
            csv.append(QUOTE).append(this.format(this.toFieldName(keyMethodName))).append(QUOTE);
        }
        csv.append(NEWLINE);
        return csv.toString();
    }

    private String toFieldName(String methodName) {
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    private String format(Object object) {
        String text = Text.toString(object);
        return Text.replace(QUOTE, "\"\"", text);
    }
}

