/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.conversion;

import java.util.HashSet;
import java.util.Set;
import nyla.solutions.core.patterns.conversion.Converter;

public class TextToEmailsConverter
implements Converter<String, Set<String>> {
    public static final String EMAIL_REG_EXP = "([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,25})$";

    @Override
    public Set<String> convert(String text) {
        if (text == null) {
            return null;
        }
        int startIndex = 0;
        int indexOfAtt = text.indexOf("@", startIndex);
        if (indexOfAtt < 0) {
            return null;
        }
        int len = text.length();
        HashSet<String> emails = new HashSet<String>();
        do {
            char c;
            char c2;
            StringBuilder prefix = new StringBuilder();
            for (int i = indexOfAtt - 1; i > -1 && (Character.isDigit(c2 = text.charAt(i)) || Character.isAlphabetic(c2) || c2 == '-' || c2 == '_' || c2 == '.'); --i) {
                prefix.append(c2);
            }
            StringBuilder end = new StringBuilder();
            for (int i = indexOfAtt + 1; i < len && (Character.isDigit(c = text.charAt(i)) || Character.isAlphabetic(c) || c == '-' || c == '_' || c == '.'); ++i) {
                end.append(c);
            }
            if (prefix.length() <= 0 && end.length() <= 0 || end.indexOf(".") <= -1) continue;
            emails.add(prefix.reverse().append("@").append((CharSequence)end).toString());
        } while ((indexOfAtt = text.indexOf("@", startIndex += indexOfAtt)) > -1);
        if (emails.isEmpty()) {
            return null;
        }
        return emails;
    }
}

