/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.generator;

import java.time.format.DateTimeFormatter;
import nyla.solutions.core.patterns.creational.Creator;
import nyla.solutions.core.patterns.creational.generator.DateTextCreator;
import nyla.solutions.core.patterns.creational.generator.EmailCreator;
import nyla.solutions.core.patterns.creational.generator.FirstNameCreator;
import nyla.solutions.core.patterns.creational.generator.FullNameCreator;
import nyla.solutions.core.patterns.creational.generator.IdCreator;
import nyla.solutions.core.patterns.creational.generator.LastNameCreator;
import nyla.solutions.core.patterns.creational.generator.PhoneNumberCreator;
import nyla.solutions.core.util.Text;

public class CreatorFactoryByPropertyName {
    private final DateTimeFormatter textDateFormat;

    public CreatorFactoryByPropertyName(DateTimeFormatter textDateFormat) {
        this.textDateFormat = textDateFormat;
    }

    public <T> Creator<T> forProperty(String property) {
        if (property == null) {
            return () -> Text.generateId();
        }
        String lowerCaseProperty = property.toLowerCase();
        Creator<String> creator = lowerCaseProperty.contains("email") ? new EmailCreator() : (lowerCaseProperty.contains("firstname") ? new FirstNameCreator() : (lowerCaseProperty.contains("lastname") ? new LastNameCreator() : (lowerCaseProperty.equals("name") || lowerCaseProperty.contains("fullname") || lowerCaseProperty.contains("customer") ? new FullNameCreator() : (lowerCaseProperty.contains("phone") || lowerCaseProperty.contains("mobile") || lowerCaseProperty.contains("fax") ? new PhoneNumberCreator() : (lowerCaseProperty.contains("date") ? new DateTextCreator(this.textDateFormat) : (lowerCaseProperty.endsWith("id") ? new IdCreator() : () -> Text.generateId()))))));
        return creator;
    }
}

