/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.decorator;

import nyla.solutions.core.data.Textable;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.patterns.decorator.TextDecorator;
import nyla.solutions.core.util.Text;

public class ParseTextDecorator
implements TextDecorator<Textable> {
    private String start = "";
    private String end = "";
    private Textable target = null;

    @Override
    public String getText() {
        if (this.target == null) {
            throw new RequiredException("this.target in ParseTextDecorator");
        }
        String text = this.target.getText();
        if (text == null || text.length() == 0) {
            return text;
        }
        return Text.parseText(text, this.start, this.end);
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    @Override
    public Textable getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Textable target) {
        this.target = target;
    }
}

