/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import nyla.solutions.core.exception.ConnectionException;
import nyla.solutions.core.patterns.jdbc.ResultSetToMapConverter;
import nyla.solutions.core.util.Cryption;
import nyla.solutions.core.util.Debugger;

public class Sql {
    public static Connection createConnection(String aDriver, String aConnectionURL, String aUser, char[] aPassword) throws ConnectionException {
        try {
            Connection connection = null;
            Class.forName(aDriver);
            String password = null;
            if (aPassword != null) {
                password = new String(aPassword);
                if (password.indexOf("{cryption}") < 0) {
                    Debugger.printWarn("Provided password is not encrypted!");
                } else {
                    password = Cryption.interpret(password);
                }
            }
            connection = DriverManager.getConnection(aConnectionURL, aUser, password);
            return connection;
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionException(e);
        }
        catch (SQLException e) {
            throw new ConnectionException(e);
        }
    }

    public <T> T queryForColumn(Connection targetConnection, String sql, int columnIndex, Class<T> returnClass) throws SQLException {
        try (Statement statement = targetConnection.createStatement();){
            Object object;
            block17: {
                ResultSet resultSet;
                block15: {
                    T t;
                    block16: {
                        resultSet = statement.executeQuery(sql);
                        try {
                            if (resultSet.next()) break block15;
                            t = null;
                            if (resultSet == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return t;
                }
                Object obj = resultSet.getObject(columnIndex);
                Class<T> objClass = obj.getClass();
                if (!objClass.isAssignableFrom(returnClass)) {
                    throw new ClassCastException("obj:" + obj + " class:" + objClass + " not assignable from " + returnClass);
                }
                object = obj;
                if (resultSet == null) break block17;
                resultSet.close();
            }
            return (T)object;
        }
    }

    public Map<String, ?> queryForMap(Connection connection, ResultSetToMapConverter converter, String sql) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            Map<String, ?> map;
            block16: {
                ResultSet resultSet;
                block14: {
                    Map<String, ?> map2;
                    block15: {
                        resultSet = stmt.executeQuery(sql);
                        try {
                            if (resultSet.next()) break block14;
                            map2 = null;
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return map2;
                }
                map = converter.convert(resultSet);
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return map;
        }
    }

    public Map<String, ?> queryForMap(Connection connection, String sql) throws SQLException {
        return this.queryForMap(connection, new ResultSetToMapConverter(), sql);
    }

    public Map<String, ?> toMap(ResultSet resultSet) {
        return this.toMap(resultSet, new ResultSetToMapConverter());
    }

    protected Map<String, ?> toMap(ResultSet resultSet, ResultSetToMapConverter converter) {
        return converter.convert(resultSet);
    }

    public void execute(Connection connection, String sql) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute(sql);
        }
    }
}

