/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.observer;

import java.time.LocalDateTime;
import nyla.solutions.core.data.clock.TimeInterval;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.decorator.TimeIntervalDecorator;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;

public class SubjectTimerObserver
implements SubjectObserver<Object>,
TimeInterval {
    private Object startData = null;
    private Object endData = null;
    private TimeIntervalDecorator decorator = null;
    private LocalDateTime startDate = null;
    private LocalDateTime endDate = null;
    private String startSubjectNamePattern = null;
    private String endSubjectNamePattern = null;

    public SubjectTimerObserver() {
    }

    public SubjectTimerObserver(TimeIntervalDecorator timeIntervalDecorator) {
        this.decorator = timeIntervalDecorator;
    }

    @Override
    public void update(String subjectName, Object data) {
        Debugger.println(this, "Recieve subject=" + subjectName);
        if (this.isStart(subjectName)) {
            this.startData = data;
            this.startDate = LocalDateTime.now();
            Debugger.printInfo(this, "TIMER START DATE [" + Text.formatDate(this.startDate) + "]\n " + Text.toString(this.startData));
        } else if (this.isEnd(subjectName)) {
            this.endData = data;
            this.endDate = LocalDateTime.now();
            Debugger.printInfo(this, "TIMER END DATE [" + this.endDate + "]\n " + this.endData);
            if (this.decorator != null) {
                this.decorator.decorator(this);
            }
        } else {
            throw new SystemException("Unknown subject " + subjectName);
        }
    }

    public boolean isStart(String name) {
        if (name == null || this.startSubjectNamePattern == null) {
            return false;
        }
        return Text.matches(name, this.startSubjectNamePattern);
    }

    public boolean isEnd(String name) {
        if (name == null || this.endSubjectNamePattern == null) {
            return false;
        }
        return Text.matches(name, this.endSubjectNamePattern);
    }

    @Override
    public String getId() {
        return this.getClass().getName() + " START:" + this.startSubjectNamePattern + " END:" + this.endSubjectNamePattern;
    }

    public String getStartSubjectNamePattern() {
        return this.startSubjectNamePattern;
    }

    public void setStartSubjectNamePattern(String startSubjectNamePattern) {
        this.startSubjectNamePattern = startSubjectNamePattern;
    }

    public String getEndSubjectNamePattern() {
        return this.endSubjectNamePattern;
    }

    public void setEndSubjectNamePattern(String endSubjectNamePattern) {
        this.endSubjectNamePattern = endSubjectNamePattern;
    }

    public TimeIntervalDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(TimeIntervalDecorator decorator) {
        this.decorator = decorator;
    }

    @Override
    public LocalDateTime getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return this.startDate;
    }

    @Override
    public void setStartDate(LocalDateTime startDate) {
        if (startDate == null) {
            this.startDate = null;
            return;
        }
        this.startDate = startDate;
    }

    @Override
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public Object getStartData() {
        return this.startData;
    }

    public void setStartData(Object startData) {
        this.startData = startData;
    }

    public Object getEndData() {
        return this.endData;
    }

    public void setEndData(Object endData) {
        this.endData = endData;
    }
}

