/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.patterns.reflection.GenericField;

public class GenericObject
implements Serializable {
    private static final long serialVersionUID = -8914553596553153625L;
    private Map<String, GenericField> fieldMap = new HashMap<String, GenericField>();
    private String objectClassName = null;

    public GenericObject(String objectClassName) {
        if (objectClassName == null) {
            throw new IllegalArgumentException("objectClassName required");
        }
        this.objectClassName = objectClassName;
    }

    public GenericObject(String objectClassName, GenericField[] fields) {
        this(objectClassName);
        this.addFields(fields);
    }

    public void addFields(GenericField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            this.fieldMap.put(fields[i].getFieldName(), fields[i]);
        }
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public GenericField[] getFields() {
        Collection<GenericField> values = this.fieldMap.values();
        if (values == null || values.isEmpty()) {
            return null;
        }
        GenericField[] fieldMirrors = new GenericField[values.size()];
        values.toArray(fieldMirrors);
        return fieldMirrors;
    }

    public GenericField retrieveField(String fieldName) {
        return this.fieldMap.get(fieldName);
    }
}

