/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.reflection.ClassSchema;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class Mirror {
    public static final String DEFAULT_DATE_FORMAT = Config.getProperty(Mirror.class, "DEFAULT_DATE_FORMAT", "MM/dd/yyyy hh:mm:ss:SS");
    private String datePattern = DEFAULT_DATE_FORMAT;
    private DateFormat dateFormat = new SimpleDateFormat(this.datePattern);
    private Object target = null;
    private Class<?> targetClass = null;
    private Map<String, Field> fieldMap = new HashMap<String, Field>();

    public Mirror(Object target) {
        this.target = target;
        this.targetClass = target.getClass();
        Field[] fields = this.targetClass.getDeclaredFields();
        Field field2 = null;
        for (Field field2 : fields) {
            this.fieldMap.put(field2.getName(), field2);
        }
    }

    public static ClassSchema toClassSchema(Class<?> aClass) throws ClassNotFoundException {
        return new ClassSchema(aClass);
    }

    public static ClassSchema toClassSchema(String className) throws ClassNotFoundException {
        return new ClassSchema(Class.forName(className));
    }

    public static Mirror newInstanceForClassName(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        className = className.trim();
        Class<?> objClass = Class.forName(className);
        return new Mirror(ClassPath.newInstance(objClass));
    }

    public static boolean isPrimitive(Class<?> aClass) {
        return ClassPath.isPrimitive(aClass);
    }

    public void setField(String fieldName, Object fieldValue) throws IllegalAccessException {
        Field field = this.fieldMap.get(fieldName);
        if (field == null) {
            throw new IllegalAccessException("field:" + fieldName + " not found");
        }
        field.setAccessible(true);
        try {
            Class<?> fieldObjClass;
            Class<?> fieldClass;
            if (fieldValue == null) {
                field.set(this.target, null);
                return;
            }
            Object fieldObj = field.get(this.target);
            if (fieldObj == null) {
                fieldObj = ClassPath.newInstance(field.getType());
            }
            if ((fieldClass = fieldObj.getClass()).equals(fieldObjClass = fieldValue.getClass())) {
                field.set(this.target, fieldValue);
            } else {
                String fiedValueString = fieldValue.toString();
                if (fieldClass == String.class) {
                    field.set(this.target, fiedValueString);
                    return;
                }
                if (fieldClass == Integer.class) {
                    field.set(this.target, Integer.valueOf(fiedValueString));
                } else if (fieldClass == Date.class) {
                    try {
                        Date date = null;
                        if (fiedValueString != null && (fiedValueString = fiedValueString.trim()).length() > 0) {
                            date = this.dateFormat.parse(fiedValueString.trim());
                        }
                        field.set(this.target, date);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e.getMessage() + " value:" + fieldValue.toString() + " format:" + this.datePattern);
                    }
                } else if (fieldClass == Double.class) {
                    field.set(this.target, Double.valueOf(fiedValueString));
                } else if (fieldClass == Long.class) {
                    field.set(this.target, Long.valueOf(fiedValueString));
                } else if (fieldClass == Short.class) {
                    field.set(this.target, Short.valueOf(fiedValueString));
                } else if (fieldClass == Character.class) {
                    field.setChar(this.target, fiedValueString.charAt(0));
                } else if (fieldClass == Byte.class) {
                    field.set(this.target, Byte.valueOf(fiedValueString));
                } else if (fieldClass == Float.class) {
                    field.set(this.target, Float.valueOf(fiedValueString));
                } else {
                    throw new RuntimeException("Not supported Class " + fieldClass.getName());
                }
            }
            field.setAccessible(false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException("field:" + field.getName() + " error:" + Debugger.stackTrace(e));
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Object getObject() {
        return this.target;
    }

    public Collection<Field> getFields() {
        return this.fieldMap.values();
    }
}

