/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.workthread;

import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.workthread.SupervisedWorker;
import nyla.solutions.core.patterns.workthread.Supervisor;
import nyla.solutions.core.patterns.workthread.WorkQueue;
import nyla.solutions.core.patterns.workthread.WorkState;

public class WorkerThread
extends Thread
implements SupervisedWorker {
    private WorkState workState = null;
    private Supervisor supervisor = null;

    public WorkerThread() {
    }

    public WorkerThread(Supervisor supervisor) {
        this.setSupervisor(supervisor);
    }

    @Override
    public Supervisor getSupervisor() {
        return this.supervisor;
    }

    @Override
    public void run() {
        if (this.supervisor == null) {
            throw new SystemException("Supervisor not set");
        }
        WorkQueue workQueue = this.supervisor.getWorkQueue();
        while (workQueue.hasMoreTasks()) {
            workQueue.nextTask().run();
        }
    }

    @Override
    public Thread getThread() {
        return this;
    }

    @Override
    public void setWorkState(WorkState workState) {
        this.workState = workState;
    }

    @Override
    public void setSupervisor(Supervisor supervisor) {
        this.supervisor = supervisor;
    }

    @Override
    public final WorkState getWorkState() {
        return this.workState;
    }
}

